/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BizLockUtils {
    private static final Log logger = LogFactory.getLog(BizLockUtils.class);
    public static final String OPER_SETTLE = "SETTLE";

    public static Set<Long> doLock(Collection<Long> needLockIds, String oper) {
        return BizLockUtils.doLock(needLockIds, oper, 1800000L);
    }

    public static Set<Long> doAllLock(Collection<Long> needLockIds, String oper) {
        return BizLockUtils.doAllLock(needLockIds, oper, 1800000L);
    }

    public static Set<Long> doAllLock(Collection<Long> needLockIds, String oper, long outTimeSec) {
        logger.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u4e1a\u52a1\u9501\u3010%s\u3011\u52a0\u9501\uff1a\u3010%s\u3011", oper, needLockIds));
        IAppCache appCache = AppCache.get((String)("ism-lock-" + oper));
        HashSet<Long> failLockIds = new HashSet<Long>(needLockIds.size());
        HashMap<Long, String> canLockIds = new HashMap<Long, String>();
        long current = System.currentTimeMillis();
        for (Long needLockId : needLockIds) {
            String key = oper + "-" + needLockId;
            String lock = (String)appCache.get(oper + "-" + needLockId, String.class);
            if (!StringUtils.isEmpty((CharSequence)lock)) {
                String[] split = lock.split("-");
                if (split.length == 2 && current - Long.parseLong(split[1]) >= outTimeSec) {
                    logger.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u4e1a\u52a1\u9501\u3010%s\u3011\u52a0\u9501\u3010%s\u3011\u6210\u529f\uff0c\u539f\u4e1a\u52a1\u9501\u5df2\u52a0\u9501\u65f6\u95f4\u8d85\u51fa%sms\u3002", oper, needLockId, outTimeSec));
                    canLockIds.put(needLockId, key);
                    continue;
                }
                failLockIds.add(needLockId);
                continue;
            }
            canLockIds.put(needLockId, key);
        }
        if (failLockIds.isEmpty()) {
            String lockMark = "LOCK-" + System.currentTimeMillis();
            for (String remarkLocKey : canLockIds.values()) {
                appCache.put(remarkLocKey, (Object)lockMark);
            }
        }
        return failLockIds;
    }

    public static Set<Long> doLock(Collection<Long> needLockIds, String oper, long outTimeSec) {
        logger.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u4e1a\u52a1\u9501\u3010%s\u3011\u52a0\u9501\uff1a\u3010%s\u3011", oper, needLockIds));
        IAppCache appCache = AppCache.get((String)("ism-lock-" + oper));
        HashSet<Long> failLockIds = new HashSet<Long>(needLockIds.size());
        long current = System.currentTimeMillis();
        String lockMark = "LOCK-" + System.currentTimeMillis();
        for (Long needLockId : needLockIds) {
            String key = oper + "-" + needLockId;
            String lock = (String)appCache.get(oper + "-" + needLockId, String.class);
            if (!StringUtils.isEmpty((CharSequence)lock)) {
                String[] split = lock.split("-");
                if (split.length == 2 && current - Long.parseLong(split[1]) >= outTimeSec) {
                    logger.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u4e1a\u52a1\u9501\u3010%s\u3011\u52a0\u9501\u3010%s\u3011\u6210\u529f\uff0c\u539f\u4e1a\u52a1\u9501\u5df2\u52a0\u9501\u65f6\u95f4\u8d85\u51fa%sms\u3002", oper, needLockId, outTimeSec));
                    appCache.put(key, (Object)lockMark);
                    continue;
                }
                failLockIds.add(needLockId);
                continue;
            }
            appCache.put(key, (Object)lockMark);
        }
        return failLockIds;
    }

    public static void releaseLock(Collection<Long> releaseLockIds, String oper) {
        IAppCache appCache = AppCache.get((String)("ism-lock-" + oper));
        for (Long releaseLock : releaseLockIds) {
            String key = oper + "-" + releaseLock;
            appCache.remove(key);
        }
        logger.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u4e1a\u52a1\u9501\u3010%s\u3011\u89e3\u9501\uff1a\u3010%s\u3011", oper, releaseLockIds));
    }
}

