/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.args;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.relation.AbstractRelationModel;
import kd.scmc.ism.model.relation.RelationEntryModel;

public class GenerateBillArgs {
    private SettleBillModel model;
    private List<ListSelectedRow> rows = new ArrayList<ListSelectedRow>(16);
    private final String sourceBillType;
    private long defOrgId = 0L;
    private String genType = null;
    private DynamicObject settleRelations;
    private RelationEntryModel entrySettlerelation;

    public static GenerateBillArgs createSupArgs(AbstractRelationModel relModel, RelationEntryModel entrySettleRelation) {
        GenerateBillArgs args = new GenerateBillArgs(relModel);
        args.entrySettlerelation = entrySettleRelation;
        args.defOrgId = entrySettleRelation.getSupplierId();
        args.genType = "supplier";
        return args;
    }

    public static GenerateBillArgs createDemArgs(AbstractRelationModel relModel, RelationEntryModel entrySettleRelation) {
        GenerateBillArgs args = new GenerateBillArgs(relModel);
        args.entrySettlerelation = entrySettleRelation;
        args.defOrgId = entrySettleRelation.getDemandId();
        args.genType = "demand";
        return args;
    }

    public static GenerateBillArgs createToOutArgs(AbstractRelationModel relModel) {
        GenerateBillArgs args = new GenerateBillArgs(relModel);
        args.genType = "toouter";
        return args;
    }

    private GenerateBillArgs(AbstractRelationModel relModel) {
        SettleBillModel srcModel;
        this.model = srcModel = relModel.getBillModel();
        this.sourceBillType = srcModel.getBillEntityType();
        this.rows.addAll(relModel.getRows().values());
        this.settleRelations = relModel.getRelationObj();
    }

    public SettleBillModel getModel() {
        return this.model;
    }

    public List<ListSelectedRow> getRows() {
        return this.rows;
    }

    public long getDefOrgId() {
        return this.defOrgId;
    }

    public DynamicObject getSettleRelations() {
        return this.settleRelations;
    }

    public DynamicObject getEntrySettlerelation() {
        if (this.entrySettlerelation == null) {
            return null;
        }
        return this.entrySettlerelation.getObj();
    }

    public RelationEntryModel getEntryModel() {
        return this.entrySettlerelation;
    }

    public String getSourceBillType() {
        return this.sourceBillType;
    }

    public String getGenType() {
        return this.genType;
    }
}

