/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.assist;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;

public abstract class AbstractPrcingAssistant {
    protected static final Log log = LogFactory.getLog(AbstractPrcingAssistant.class);
    protected Map<String, Map<String, Object>> pricingResult = new HashMap<String, Map<String, Object>>(64);
    protected Map<String, String> failInfos = new HashMap<String, String>(64);
    protected Map<String, CoupleSettleBillEntriesModel> cpBills = new HashMap<String, CoupleSettleBillEntriesModel>(128);

    protected abstract String getCacheKey(CoupleSettleBillEntriesModel var1);

    protected abstract void doQuote();

    public void preLoad(Collection<CoupleSettleBillEntriesModel> models) {
        for (CoupleSettleBillEntriesModel model : models) {
            String cacheKey = this.getCacheKey(model);
            if (this.pricingResult.containsKey(cacheKey) || this.failInfos.containsKey(cacheKey)) continue;
            this.cpBills.put(cacheKey, model);
        }
    }

    public String getFailInfo(CoupleSettleBillEntriesModel cpModel) {
        String cacheKey = this.getCacheKey(cpModel);
        return this.failInfos.get(cacheKey);
    }

    public <T> T getQuoteValue(CoupleSettleBillEntriesModel cpModel, String fieldKey, T defaultValue) {
        Object value = this.getQuoteValue(cpModel, fieldKey);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public Object getQuoteValue(CoupleSettleBillEntriesModel cpModel, String fieldKey) {
        Map<String, Object> map = this.getQuoteValues(cpModel);
        if (map != null) {
            return map.get(fieldKey);
        }
        return null;
    }

    public Map<String, Object> getQuoteValues(CoupleSettleBillEntriesModel cpModel) {
        String cacheKey = this.getCacheKey(cpModel);
        if (!this.pricingResult.containsKey(cacheKey) && !this.failInfos.containsKey(cacheKey)) {
            this.cpBills.put(cacheKey, cpModel);
            this.doQuote();
        }
        return this.pricingResult.get(cacheKey);
    }
}

