/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.assist;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.common.model.mapper.CurrencyAndExRateTableCacheMapper;
import kd.scmc.ism.common.model.mapper.OrgAndSupplierCustomerMapper;
import kd.scmc.ism.common.utils.CommonUtils;

public class OrgAssistant {
    private Set<Long> orgIds = new HashSet<Long>(16);
    private Map<Long, DynamicObject> orgObjs = new HashMap<Long, DynamicObject>(16);
    private OrgAndSupplierCustomerMapper supCusMapper = new OrgAndSupplierCustomerMapper();
    private CurrencyAndExRateTableCacheMapper exrateTableMapper = new CurrencyAndExRateTableCacheMapper();

    public void preLoadData(Long orgId) {
        this.orgIds.add(orgId);
    }

    public void preLoadDatas(Collection<Long> orgIds) {
        this.orgIds.addAll(orgIds);
    }

    private void doloadData() {
        this.orgIds.removeAll(this.orgObjs.keySet());
        this.orgIds.remove(0L);
        if (!this.orgIds.isEmpty()) {
            Map objs = BusinessDataServiceHelper.loadFromCache((Object[])this.orgIds.toArray(), (String)"bos_org");
            for (Long orgId : this.orgIds) {
                this.orgObjs.put(orgId, (DynamicObject)objs.get(orgId));
            }
            this.supCusMapper.load(this.orgIds);
        }
        this.orgIds.clear();
    }

    private void doLoad(Long org) {
        if (!this.orgObjs.containsKey(org)) {
            this.orgIds.add(org);
            this.doloadData();
        }
    }

    public DynamicObject getOrgObj(Long org) {
        this.doLoad(org);
        return this.orgObjs.get(org);
    }

    public DynamicObject getInnerCustomerObj(Long org) {
        if (CommonUtils.idIsNull(org)) {
            return null;
        }
        this.doLoad(org);
        return this.supCusMapper.getInnerCustomerByOrgId(org);
    }

    public DynamicObject getInnerSupplier(Long org) {
        if (CommonUtils.idIsNull(org)) {
            return null;
        }
        this.doLoad(org);
        return this.supCusMapper.getInnerSupplierByOrgId(org);
    }

    public long getOrgCurrency(Long orgId) {
        Map<String, Long> map = this.exrateTableMapper.get(orgId);
        if (map == null) {
            return 0L;
        }
        return map.get("baseCurrencyID");
    }

    public long getOrgExrateTable(Long orgId) {
        Map<String, Long> map = this.exrateTableMapper.get(orgId);
        if (map == null) {
            return 0L;
        }
        return map.get("exchangeRateTableID");
    }
}

