/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.billgenerator.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.scmc.ism.business.helper.BotpPushHepler;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.args.GenerateBillArgs;
import kd.scmc.ism.common.model.args.GenerateResult;
import kd.scmc.ism.common.model.billgenerator.BillGenerator;
import kd.scmc.ism.lang.ModelLang;

public class BOTPBillGenerator
extends BillGenerator {
    private static final String ISM_PREFIX = "ism@";
    private String botpid = null;

    @Override
    public GenerateResult generateBill(ISMServiceContext service, GenerateBillArgs args) {
        GenerateResult generate = this.generate(service, args);
        generate.setBotpid(this.botpid);
        return generate;
    }

    private GenerateResult generate(ISMServiceContext service, GenerateBillArgs args) {
        PushArgs pushArgs = new PushArgs(this.getSourceBillType(), this.getTargetBillType(), args.getRows());
        pushArgs.setRuleId(this.botpid);
        DynamicObject settleRelations = args.getSettleRelations();
        DynamicObject entrySettleRelations = args.getEntrySettlerelation();
        pushArgs.addCustomParam("settleRelation", String.valueOf(settleRelations != null ? settleRelations.getLong("id") : 0L));
        pushArgs.addCustomParam("entrysettleRelation", String.valueOf(entrySettleRelations != null ? entrySettleRelations.getLong("id") : 0L));
        Map<String, Object> funcCacheValue = this.buildFuncCacheValue(settleRelations);
        for (Map.Entry<String, Object> funCacheEntry : funcCacheValue.entrySet()) {
            pushArgs.addCustomParam(funCacheEntry.getKey(), String.valueOf(funCacheEntry.getValue()));
        }
        ConvertOperationResult convertResult = BotpPushHepler.push(pushArgs);
        if (!convertResult.isSuccess()) {
            return GenerateResult.createFailResult(ModelLang.botpPushFail(convertResult, this.botpid));
        }
        List<DynamicObject> purInBills = BotpPushHepler.getTargetObjectWithRefence(convertResult);
        if (purInBills == null || purInBills.size() == 0) {
            return GenerateResult.createFailResult(ModelLang.botpConfigFail(convertResult, this.botpid));
        }
        DynamicObject targetBill = purInBills.get(0);
        return GenerateResult.createSuccessResult(targetBill, service.getMapCfg());
    }

    public void setBotpid(String botpid) {
        this.botpid = botpid;
    }

    private Map<String, Object> buildFuncCacheValue(DynamicObject settleRelation) {
        HashMap<String, Object> mapValue = new HashMap<String, Object>();
        DynamicObject settleOrg = settleRelation.getDynamicObject("settleorg");
        Object settleOrgId = settleOrg == null ? Long.valueOf(0L) : settleOrg.getPkValue();
        DynamicObject ownerOrg = settleRelation.getDynamicObject("owner");
        Object ownerOrgId = ownerOrg == null ? Long.valueOf(0L) : ownerOrg.getPkValue();
        mapValue.put("ism@funcCache", "true");
        mapValue.put("ism@settleorg", settleOrgId);
        mapValue.put("ism@owner", ownerOrgId);
        for (DynamicObject entryRelation : settleRelation.getDynamicObjectCollection("settlerelationdetail")) {
            Object entryId = entryRelation.getPkValue();
            if (!mapValue.containsKey("ism@fristEntry")) {
                mapValue.put("ism@fristEntry", entryId);
            }
            mapValue.put("ism@lastEntry", entryId);
            mapValue.put(ISM_PREFIX + entryId + "@" + "supplier", entryRelation.getDynamicObject("supplier") == null ? Long.valueOf(0L) : entryRelation.getDynamicObject("supplier").getPkValue());
            mapValue.put(ISM_PREFIX + entryId + "@" + "saleorg", entryRelation.getDynamicObject("saleorg") == null ? Long.valueOf(0L) : entryRelation.getDynamicObject("saleorg").getPkValue());
            mapValue.put(ISM_PREFIX + entryId + "@" + "supplierwarehouseorg", entryRelation.getDynamicObject("supplierwarehouseorg") == null ? Long.valueOf(0L) : entryRelation.getDynamicObject("supplierwarehouseorg").getPkValue());
            mapValue.put(ISM_PREFIX + entryId + "@" + "supplierwarehouse", entryRelation.getDynamicObject("supplierwarehouse") == null ? Long.valueOf(0L) : entryRelation.getDynamicObject("supplierwarehouse").getPkValue());
            mapValue.put(ISM_PREFIX + entryId + "@" + "supplierlocation", entryRelation.getDynamicObject("supplierlocation") == null ? Long.valueOf(0L) : entryRelation.getDynamicObject("supplierlocation").getPkValue());
            mapValue.put(ISM_PREFIX + entryId + "@" + "demand", entryRelation.getDynamicObject("demand") == null ? Long.valueOf(0L) : entryRelation.getDynamicObject("demand").getPkValue());
            mapValue.put(ISM_PREFIX + entryId + "@" + "purorg", entryRelation.getDynamicObject("purorg") == null ? Long.valueOf(0L) : entryRelation.getDynamicObject("purorg").getPkValue());
            mapValue.put(ISM_PREFIX + entryId + "@" + "demandwarehouseorg", entryRelation.getDynamicObject("demandwarehouseorg") == null ? Long.valueOf(0L) : entryRelation.getDynamicObject("demandwarehouseorg").getPkValue());
            mapValue.put(ISM_PREFIX + entryId + "@" + "demandwarehouse", entryRelation.getDynamicObject("demandwarehouse") == null ? Long.valueOf(0L) : entryRelation.getDynamicObject("demandwarehouse").getPkValue());
            mapValue.put(ISM_PREFIX + entryId + "@" + "demandlocation", entryRelation.getDynamicObject("demandlocation") == null ? Long.valueOf(0L) : entryRelation.getDynamicObject("demandlocation").getPkValue());
        }
        return mapValue;
    }
}

