/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.mapper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ExRateCacheMapper {
    private static final String EXCHANGE_RATE = "exchangeRate";
    private static final String QUOTE_TYPE = "quoteType";
    private Map<String, BigDecimal> map = new HashMap<String, BigDecimal>(16);
    private Map<String, String> quotationMap = new HashMap<String, String>(16);
    private Set<String> noneExrate = new HashSet<String>();

    public String getQuotation(long exchangeTableID, long sourceCurrencyID, long targetCurrencyID, Date date) {
        String key = this.getKey(exchangeTableID, sourceCurrencyID, targetCurrencyID, date);
        String quotation = this.quotationMap.get(key);
        if (StringUtils.isEmpty((CharSequence)quotation) && !this.noneExrate.contains(key)) {
            quotation = (String)this.getExrateInfo(exchangeTableID, sourceCurrencyID, targetCurrencyID, date, key).get(QUOTE_TYPE);
        }
        return quotation;
    }

    public BigDecimal getExRate(long exchangeTableID, long sourceCurrencyID, long targetCurrencyID, Date date) {
        String key = this.getKey(exchangeTableID, sourceCurrencyID, targetCurrencyID, date);
        BigDecimal exRate = this.map.get(key);
        if (exRate == null && !this.noneExrate.contains(key)) {
            exRate = (BigDecimal)this.getExrateInfo(exchangeTableID, sourceCurrencyID, targetCurrencyID, date, key).get(EXCHANGE_RATE);
        }
        return exRate;
    }

    private Map<String, Object> getExrateInfo(long exchangeTableID, long sourceCurrencyID, long targetCurrencyID, Date date, String key) {
        BigDecimal exRate = null;
        String quotation = "0";
        if (targetCurrencyID == sourceCurrencyID) {
            exRate = BigDecimal.ONE;
        } else if (sourceCurrencyID == 0L || targetCurrencyID == 0L) {
            exRate = null;
        } else {
            Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)sourceCurrencyID, (Long)targetCurrencyID, (Long)exchangeTableID, (Date)date);
            if (((Boolean)exchangeRateMap.get(QUOTE_TYPE)).booleanValue()) {
                quotation = "1";
            }
            exRate = (BigDecimal)exchangeRateMap.get(EXCHANGE_RATE);
        }
        if (exRate == null) {
            this.noneExrate.add(key);
        }
        this.map.put(key, exRate);
        this.quotationMap.put(key, quotation);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put(EXCHANGE_RATE, exRate);
        resultMap.put(QUOTE_TYPE, quotation);
        return resultMap;
    }

    public final String getKey(long exchangeTableID, long sourceCurrencyID, long targetCurrencyID, Date date) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(exchangeTableID);
        stringBuilder.append('-');
        stringBuilder.append(sourceCurrencyID);
        stringBuilder.append('-');
        stringBuilder.append(targetCurrencyID);
        stringBuilder.append('-');
        if (date == null) {
            stringBuilder.append(0);
        } else {
            stringBuilder.append(date.getTime());
        }
        return stringBuilder.toString();
    }
}

