/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.mapper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.common.model.entity.MaterialUnitEntity;
import kd.scmc.ism.common.model.mapper.AbstractMapper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;

public class MaterialUnitConvertMapper
extends AbstractMapper<Long, MaterialUnitEntity> {
    @Override
    protected List<MaterialUnitEntity> handle(Collection<Long> objects) {
        Map materialUnits = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (QFilter[])new QFilter("materialid", "in", objects).toArray());
        if (CommonUtils.mapIsEmpty(materialUnits)) {
            return null;
        }
        Map materialInfo = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id, baseunit", (QFilter[])new QFilter("id", "in", objects).toArray());
        for (DynamicObject materialUnit : materialUnits.values()) {
            long materialId = DynamicObjectUtil.getPkValue(materialUnit.getDynamicObject("materialid"));
            MaterialUnitEntity materialUnitEntity = (MaterialUnitEntity)this.map.get(materialId);
            if (materialUnitEntity == null) {
                DynamicObject materialObj = (DynamicObject)materialInfo.get(materialId);
                long baseUnitId = DynamicObjectUtil.getPkValue(materialObj.getDynamicObject("baseunit"));
                materialUnitEntity = new MaterialUnitEntity(materialId, baseUnitId);
                this.map.put(materialId, materialUnitEntity);
            }
            materialUnitEntity.addMaterialUnitInfo(materialUnit);
        }
        return null;
    }

    public BigDecimal getUnitConvert(long materialid, BigDecimal srcQty, long sourceUnit, long targetUnitId) {
        MaterialUnitEntity materialUnitEntity = (MaterialUnitEntity)this.get(materialid);
        if (materialUnitEntity != null) {
            return materialUnitEntity.getConvertQty(srcQty, sourceUnit, targetUnitId);
        }
        return srcQty;
    }
}

