/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.currency;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.assist.OrgAssistant;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.currency.AbstractCurrencyPricing;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;

public class InCustomerCurrencyPricing
extends AbstractCurrencyPricing {
    public InCustomerCurrencyPricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillsModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        OrgAssistant orgAssistant = this.getServiceContext().getOrgAssistant();
        for (CoupleSettleBillsModel model : models) {
            long billId = model.getId();
            Long demandOrg = model.getDemandId();
            DynamicObject innerCustomer = orgAssistant.getInnerCustomerObj(demandOrg);
            if (innerCustomer == null) {
                String failReason = ResManager.loadKDString((String)"\u9700\u6c42\u65b9\u7ed3\u7b97\u7ec4\u7ec7\u6ca1\u6709\u5185\u90e8\u5ba2\u6237\u3002", (String)"DemandOrgHasNotInnerCustomer", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, billId, pricingkey, failReason);
                continue;
            }
            DynamicObject currency = innerCustomer.getDynamicObject("settlementcyid");
            if (currency == null) {
                String failReason = ResManager.loadKDString((String)"\u9700\u6c42\u65b9\u7ed3\u7b97\u7ec4\u7ec7\u7684\u5185\u90e8\u5ba2\u6237\u672a\u8bbe\u7f6e\u7ed3\u7b97\u5e01\u3002", (String)"DemandOrgInnerCustomerNotSetCurrency", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, billId, pricingkey, failReason);
                continue;
            }
            this.setCurrencyAndLog(currency, model, logHandler, pricingkey);
            ids.add(billId);
        }
        return ids;
    }
}

