/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.currency;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.assist.OrgAssistant;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.currency.AbstractCurrencyPricing;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;

public class SettleDemCurrencyPricing
extends AbstractCurrencyPricing {
    public SettleDemCurrencyPricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillsModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        OrgAssistant orgAssistant = this.getServiceContext().getOrgAssistant();
        PricingLogHandler logHandler = context.getPricingLogHandler();
        for (CoupleSettleBillsModel model : models) {
            long billId = model.getId();
            Long demand = model.getDemandId();
            long priceCurrencyId = orgAssistant.getOrgCurrency(demand);
            if (priceCurrencyId == 0L) {
                String failReason = ResManager.loadKDString((String)"\u9700\u6c42\u65b9\u7ed3\u7b97\u7ec4\u7ec7\u6ca1\u6709\u672c\u4f4d\u5e01\u3002", (String)"DemandOrgHasNotSetCurrency", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, billId, pricingkey, failReason);
                continue;
            }
            this.setCurrencyAndLog(priceCurrencyId, model, logHandler, pricingkey);
            ids.add(billId);
        }
        return ids;
    }
}

