/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.currency;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.assist.OrgAssistant;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.currency.AbstractCurrencyPricing;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;

public class SettleSupCurrencyPricing
extends AbstractCurrencyPricing {
    public SettleSupCurrencyPricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillsModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        OrgAssistant orgAssistant = this.getServiceContext().getOrgAssistant();
        PricingLogHandler logHandler = context.getPricingLogHandler();
        for (CoupleSettleBillsModel model : models) {
            long billId = model.getId();
            Long supplier = model.getSupplierId();
            long currencyId = orgAssistant.getOrgCurrency(supplier);
            if (CommonUtils.idIsNull(currencyId)) {
                String failReason = ResManager.loadKDString((String)"\u4f9b\u5e94\u65b9\u7ed3\u7b97\u7ec4\u7ec7\u6ca1\u6709\u672c\u4f4d\u5e01\u3002", (String)"SupplierOrgHasNotSetCurrency", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, billId, pricingkey, failReason);
                continue;
            }
            this.setCurrencyAndLog(currencyId, model, logHandler, pricingkey);
            ids.add(billId);
        }
        return ids;
    }
}

