/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.currency;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.currency.AbstractCurrencyPricing;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;

public class SpecifyCurrencyPricing
extends AbstractCurrencyPricing {
    public SpecifyCurrencyPricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillsModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        for (CoupleSettleBillsModel model : models) {
            long billId = model.getId();
            DynamicObject priceRuleObj = model.getPriceRuleObj();
            DynamicObject priceRule = (DynamicObject)priceRuleObj.getDynamicObjectCollection("entryentity").get(0);
            DynamicObject currency = priceRule.getDynamicObject("currencyinfo");
            long currencyId = DynamicObjectUtil.getPkValue(currency);
            if (currencyId == 0L) {
                String failReason = ResManager.loadKDString((String)"\u53d6\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5e01\u79cd\u3002", (String)"PriceRuleNotSetCurrency", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, billId, pricingkey, failReason);
                continue;
            }
            this.setCurrencyAndLog(currencyId, model, logHandler, pricingkey);
            ids.add(billId);
        }
        return ids;
    }
}

