/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.currency;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.currency.AbstractCurrencyPricing;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;

public class SrcBizBillCurrencyPricing
extends AbstractCurrencyPricing {
    public SrcBizBillCurrencyPricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillsModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        for (CoupleSettleBillsModel model : models) {
            String failReason;
            long billId = model.getId();
            SettleBillModel srcBillObj = (SettleBillModel)model.getSrcBillModel();
            Long srcBillId = (Long)model.getValue("srcbillid");
            if (CommonUtils.idIsNull(srcBillId) || srcBillObj == null) {
                failReason = ResManager.loadKDString((String)"\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"BizBillNotExist", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, billId, pricingkey, failReason);
                continue;
            }
            if (!this.isConfigField(srcBillObj.getBillEntityType(), "settlecy")) {
                failReason = ResManager.loadKDString((String)"\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u7ed3\u7b97\u5e01\u5b57\u6bb5\u3002", (String)"BizBillCurrencyKeyNotConfig", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, billId, pricingkey, failReason);
                continue;
            }
            DynamicObject currency = (DynamicObject)srcBillObj.getValue("settlecy");
            if (CommonUtils.isNull(currency)) {
                String failReason2 = ResManager.loadKDString((String)"\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u7ed3\u7b97\u5e01\u5b57\u6bb5\u503c\u4e3a\u7a7a\u3002", (String)"BizBillCurrencyIsNull", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, billId, pricingkey, failReason2);
                continue;
            }
            this.setCurrencyAndLog(currency, model, logHandler, pricingkey);
            ids.add(billId);
        }
        return ids;
    }
}

