/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.price;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.assist.AbstractPolicyPricingAssistant;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.price.AbstractPricePricing;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;

public abstract class AbstractPolicyPricePricing
extends AbstractPricePricing {
    public AbstractPolicyPricePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        AbstractPolicyPricingAssistant policyService = this.getPolicyAssistant();
        policyService.preLoad(models);
        for (CoupleSettleBillEntriesModel model : models) {
            BigDecimal taxprice = (BigDecimal)policyService.getQuoteValue(model, "priceandtax");
            BigDecimal price = (BigDecimal)policyService.getQuoteValue(model, "price");
            if (taxprice == null && price == null) {
                String failInfo = policyService.getFailInfo(model);
                if (StringUtils.isEmpty((CharSequence)failInfo)) {
                    failInfo = PricingLang.priceFail();
                }
                logHandler.logFailInfo("price", model.getId(), pricingkey, failInfo);
                continue;
            }
            if (!this.validateZeroPrice(pricingkey, logHandler, model, taxprice, price)) continue;
            Long settlecy = (Long)policyService.getQuoteValue(model, "settlecy");
            if (settlecy == null || settlecy.equals(0L)) {
                settlecy = model.getBillModel().getSettleCurrencyId();
            }
            Long unitId = policyService.getQuoteValue(model, "unit", 0L);
            this.setPriceAndLog(taxprice, price, settlecy, unitId, model, logHandler, pricingkey);
            ids.add(model.getId());
        }
        return ids;
    }

    protected abstract AbstractPolicyPricingAssistant getPolicyAssistant();
}

