/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.price;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.price.AbstractPricePricing;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;

public class SrcBillPricePricing
extends AbstractPricePricing {
    public SrcBillPricePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        SettleBillMapCfg mapCfg = this.getServiceContext().getMapCfg();
        for (CoupleSettleBillEntriesModel model : models) {
            SettleBillEntryModel srcBillEntryModel = (SettleBillEntryModel)model.getSrcBillModel();
            Long srcEntry = (Long)model.getValue("srcbillentryid");
            if (CommonUtils.idIsNull(srcEntry) || srcBillEntryModel == null) {
                String failReason = ResManager.loadKDString((String)"\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u5206\u5f55\u4e3a\u7a7a\u3002", (String)"BizBillEntryIsNull", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, model.getId(), pricingkey, failReason);
                continue;
            }
            SettleBillModel srcbillModel = (SettleBillModel)model.getBillModel().getSrcBillModel();
            String taxPriceKey = mapCfg.getFieldKey(srcbillModel.getBillEntityType(), "priceandtax");
            String priceKey = mapCfg.getFieldKey(srcbillModel.getBillEntityType(), "price");
            if (StringUtils.isEmpty((CharSequence)taxPriceKey) && StringUtils.isEmpty((CharSequence)priceKey)) {
                String failReason = PricingLang.bizBillPriceKeyNotConfig();
                this.logFailInfo(logHandler, model.getId(), pricingkey, failReason);
                continue;
            }
            BigDecimal taxprice = (BigDecimal)srcBillEntryModel.getValue("priceandtax");
            BigDecimal price = (BigDecimal)srcBillEntryModel.getValue("price");
            if (price == null && taxprice == null) {
                String failReason = PricingLang.bizBillPriceIsNull();
                this.logFailInfo(logHandler, model.getId(), pricingkey, failReason);
                continue;
            }
            if (!this.validateZeroPrice(pricingkey, logHandler, model, taxprice, price)) continue;
            DynamicObject srcCurrency = (DynamicObject)srcbillModel.getValue("settlecy");
            DynamicObject unit = (DynamicObject)srcBillEntryModel.getValue("unit");
            this.setPriceAndLog(taxprice, price, DynamicObjectUtil.getPkValue(srcCurrency), DynamicObjectUtil.getPkValue(unit), model, logHandler, pricingkey);
            ids.add(model.getId());
        }
        return ids;
    }
}

