/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.taxrate;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.assist.AbstractPolicyPricingAssistant;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.taxrate.AbstractTaxRatePricing;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;

public abstract class AbstractPolicyTaxRatePricing
extends AbstractTaxRatePricing {
    public AbstractPolicyTaxRatePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        AbstractPolicyPricingAssistant policyService = this.getPolicyAssistant();
        policyService.preLoad(models);
        for (CoupleSettleBillEntriesModel model : models) {
            Long taxRate = (Long)policyService.getQuoteValue(model, "taxrateid");
            if (taxRate == null || taxRate == 0L) {
                String failInfo = policyService.getFailInfo(model);
                if (StringUtils.isEmpty((CharSequence)failInfo)) {
                    failInfo = PricingLang.taxrateFail();
                }
                logHandler.logFailInfo("taxrate", model.getId(), pricingkey, failInfo);
                continue;
            }
            this.setTaxRateAndLog(taxRate, model, logHandler, pricingkey);
            ids.add(model.getId());
        }
        return ids;
    }

    protected abstract AbstractPolicyPricingAssistant getPolicyAssistant();
}

