/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.taxrate;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.taxrate.AbstractTaxRatePricing;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;

public class SpecifyTaxRatePricing
extends AbstractTaxRatePricing {
    public SpecifyTaxRatePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        for (CoupleSettleBillEntriesModel model : models) {
            DynamicObject priceRuleObj = model.getPriceRuleEntryObj();
            DynamicObject taxrate = priceRuleObj.getDynamicObject("taxrate");
            long taxrateId = DynamicObjectUtil.getPkValue(taxrate);
            if (taxrateId == 0L) {
                String failReason = ResManager.loadKDString((String)"\u53d6\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u7a0e\u7387\u3002", (String)"PriceRuleNotSetTaxRate", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.logFailInfo(logHandler, model.getId(), pricingkey, failReason);
                continue;
            }
            this.setTaxRateAndLog(taxrateId, model, logHandler, pricingkey);
            ids.add(model.getId());
        }
        return ids;
    }
}

