/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.pricing.impl.taxrate;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.pricing.impl.taxrate.AbstractTaxRatePricing;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;

public class SrcBillTaxRatePricing
extends AbstractTaxRatePricing {
    public SrcBillTaxRatePricing(ISMServiceContext serviceContext) {
        super(serviceContext);
    }

    @Override
    public Set<Long> handlePricing(String pricingkey, Collection<CoupleSettleBillEntriesModel> models, ISMRequestContext context) {
        HashSet<Long> ids = new HashSet<Long>(models.size());
        PricingLogHandler logHandler = context.getPricingLogHandler();
        for (CoupleSettleBillEntriesModel model : models) {
            SettleBillEntryModel srcEntryBillModel = (SettleBillEntryModel)model.getSrcBillModel();
            Long srcEntry = (Long)model.getValue("srcbillentryid");
            if (CommonUtils.idIsNull(srcEntry) || srcEntryBillModel == null) {
                String failReason = ResManager.loadKDString((String)"\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u5206\u5f55\u4e3a\u7a7a\u3002", (String)"BizBillEntryIsNull", (String)"scmc-ism-form", (Object[])new Object[0]);
                logHandler.logFailInfo("taxrate", model.getId(), pricingkey, failReason);
                continue;
            }
            SettleBillModel srcbillModel = (SettleBillModel)model.getBillModel().getSrcBillModel();
            if (!this.isConfigField(srcbillModel.getBillEntityType(), "taxrateid")) {
                String failReason = ResManager.loadKDString((String)"\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u7a0e\u7387\u5b57\u6bb5\u3002", (String)"BizBillTaxRateKeyNotConfig", (String)"scmc-ism-form", (Object[])new Object[0]);
                logHandler.logFailInfo("taxrate", model.getId(), pricingkey, failReason);
                continue;
            }
            DynamicObject taxRateObj = (DynamicObject)srcEntryBillModel.getValue("taxrateid");
            if (CommonUtils.isNull(taxRateObj)) {
                String failReason = ResManager.loadKDString((String)"\u6765\u6e90\u4e1a\u52a1\u5355\u636e\u7a0e\u7387\u5b57\u6bb5\u503c\u4e3a\u7a7a\u3002", (String)"BizBillTaxRateIsNull", (String)"scmc-ism-form", (Object[])new Object[0]);
                logHandler.logFailInfo("taxrate", model.getId(), pricingkey, failReason);
                continue;
            }
            this.setTaxRateAndLog(taxRateObj, model, logHandler, pricingkey);
            ids.add(model.getId());
        }
        return ids;
    }
}

