/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.settlebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.business.action.SettleActionFactory;
import kd.scmc.ism.business.action.SettleActionProcessor;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;

public class SettleBillChecker {
    public SettleOperResult check(List<DynamicObject> billObjs) {
        ISMServiceContext serviceContext = ISMServiceContext.buildCheck();
        SettleBillMapCfg mapCfg = serviceContext.getMapCfg();
        if (!mapCfg.isContain(billObjs.get(0).getDataEntityType().getName())) {
            return new SettleOperResult();
        }
        ArrayList<SettleBillModel> billModels = new ArrayList<SettleBillModel>(billObjs.size());
        for (DynamicObject billObj : billObjs) {
            SettleBillModel model = SettleBillModel.build(billObj, mapCfg);
            billModels.add(model);
        }
        ISMRequestContext req = ISMRequestContext.create(billModels);
        SettleActionProcessor processor = SettleActionProcessor.build(SettleActionFactory.buildCheckSettleActions(), serviceContext);
        processor.doProcess(req);
        return req.getOperResult();
    }
}

