/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.settlebill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.model.core.BizLocker;
import kd.scmc.ism.model.core.impl.SettleOperFailInfoHandle;
import kd.scmc.ism.model.core.unsettle.IUnSettleOper;
import kd.scmc.ism.model.core.unsettle.UnSettleOperSplitter;
import kd.scmc.ism.model.core.unsettle.impl.DeleteRecordOper;
import kd.scmc.ism.model.core.unsettle.impl.UnSettleOperExecute;

public class SettleBillDeleter {
    private List<IUnSettleOper> unSettleOpers = new ArrayList<IUnSettleOper>(16);
    protected static final Log logger = LogFactory.getLog(SettleBillDeleter.class);

    public SettleBillDeleter() {
        this.unSettleOpers.add(new UnSettleOperExecute());
        this.unSettleOpers.add(new SettleOperFailInfoHandle());
        this.unSettleOpers.add(new DeleteRecordOper());
    }

    public SettleOperResult executeDeleteBySourceBills(List<Long> sourceBillIds) {
        SettleOperResult result = new SettleOperResult();
        try (BizLocker locker = BizLocker.create(sourceBillIds, "SETTLE");){
            Set<Long> lockedIds = locker.getLockedIds();
            logger.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u6267\u884c\u53cd\u7ed3\u7b97\uff1a\u3010%s\u3011", sourceBillIds));
            UnSettleOperSplitter spo = UnSettleOperSplitter.doParseByBillIds(lockedIds);
            result.combine(this.doUnSettle(spo));
            for (Map.Entry<Long, ErrorCode> lockFailInfo : locker.getLockFailedInfos().entrySet()) {
                result.addFailInfo(lockFailInfo.getKey(), lockFailInfo.getValue());
            }
        }
        return result;
    }

    public SettleOperResult executeDeleteByLogs(List<Long> logIds) {
        UnSettleOperSplitter spo = UnSettleOperSplitter.doParseByLogIds(logIds);
        return this.doUnSettle(spo);
    }

    private SettleOperResult doUnSettle(UnSettleOperSplitter spo) {
        SettleOperResult result = new SettleOperResult();
        for (IUnSettleOper oper : this.unSettleOpers) {
            TraceSpan trace = Tracer.create((String)("SettleBillDeleter-" + oper.getClass().getName()), (String)"doSettleOper()");
            Throwable throwable = null;
            try {
                result.combine(oper.doSettleOper(spo));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (trace == null) continue;
                if (throwable != null) {
                    try {
                        trace.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                trace.close();
            }
        }
        return result;
    }
}

