/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.result;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.scmc.ism.business.helper.ResultInfoHelper;
import kd.scmc.ism.common.errocode.ISMErrorCode;
import kd.scmc.ism.common.result.AbstractResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.ErrorCodeUtils;

public class SettleOperResult
extends AbstractResult {
    private Map<Long, List<ErrorCode>> failReasons = new HashMap<Long, List<ErrorCode>>(32);

    public SettleOperResult() {
        this.setSuccess(true);
    }

    public void combine(SettleOperResult oresult) {
        if (oresult == null) {
            return;
        }
        Map<Long, List<ErrorCode>> oReasons = oresult.getFailCodes();
        for (Map.Entry<Long, List<ErrorCode>> oReasonEntrys : oReasons.entrySet()) {
            this.addFailInfo(oReasonEntrys.getKey(), oReasonEntrys.getValue());
        }
    }

    public void batchAddFailInfo(Collection<Long> billIds, String failReason) {
        for (Long billId : billIds) {
            this.addFailInfo(billId, failReason);
        }
    }

    public void addFailInfo(Long billId, String failReason) {
        this.addFailInfo(billId, ISMErrorCode.commonCode(failReason));
    }

    public void addFailInfo(Long billId, List<ErrorCode> erroCodes) {
        this.setSuccess(false);
        List<ErrorCode> erroCodeList = CommonUtils.mapGetListValue(this.failReasons, billId);
        erroCodeList.addAll(erroCodes);
    }

    public void addFailInfo(Long billId, ErrorCode erroCode) {
        this.setSuccess(false);
        List<ErrorCode> erroCodeList = CommonUtils.mapGetListValue(this.failReasons, billId);
        erroCodeList.add(erroCode);
    }

    public Map<String, Object> toMapInfo() {
        if (this.isSuccess()) {
            return ResultInfoHelper.buildSuccessResult();
        }
        return ResultInfoHelper.buildFailResult(this.getFailReasonJsonStr());
    }

    public Map<String, Object> toMapInfo(Map<Long, String> idToBillNos) {
        if (this.isSuccess()) {
            return ResultInfoHelper.buildSuccessResult();
        }
        Map<String, Object> billFailInfo = this.getFailReasonsWithNo(idToBillNos);
        return ResultInfoHelper.buildFailResult(SerializationUtils.toJsonString(billFailInfo));
    }

    public String toString() {
        return "SettleOperResult [failReasons=" + this.failReasons + "]";
    }

    public String getFailReasonJsonStr() {
        return SerializationUtils.toJsonString(this.failReasons);
    }

    public Map<Long, List<ErrorCode>> getFailCodes() {
        return this.failReasons;
    }

    public Map<Long, String> getFailReasons() {
        HashMap<Long, String> failReasonMap = new HashMap<Long, String>(32);
        for (Map.Entry<Long, List<ErrorCode>> mapEntry : this.failReasons.entrySet()) {
            failReasonMap.put(mapEntry.getKey(), ErrorCodeUtils.parseErroCode(mapEntry.getValue()));
        }
        return failReasonMap;
    }

    public Map<String, Object> getFailReasonsWithNo(Map<Long, String> idToBillNos) {
        Map<Long, String> failReasons = this.getFailReasons();
        HashMap<String, Object> billFailInfo = new HashMap<String, Object>(failReasons.size());
        for (Map.Entry<Long, String> info : failReasons.entrySet()) {
            String billNo = idToBillNos.get(info.getKey());
            if (billNo == null) {
                billNo = String.valueOf(info.getKey());
            }
            billFailInfo.put(billNo, info.getValue());
        }
        return billFailInfo;
    }
}

