/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class DataSetUtils {
    public static DataSet innerJoinDataSet(DataSet a, String aOnFiled, DataSet b, String bOnFiled) {
        return DataSetUtils.joinDataSet(a, aOnFiled, b, bOnFiled, JoinType.INNER);
    }

    public static DataSet joinDataSet(DataSet a, String aOnFiled, DataSet b, String bOnFiled, JoinType paramJoinType) {
        return a.join(b, paramJoinType).on(aOnFiled, bOnFiled).select(a.getRowMeta().getFieldNames(), b.getRowMeta().getFieldNames()).finish();
    }

    public static DataSet buildDataSet(String algokey, Map<String, DataType> metaInfos, Collection<Object[]> values) {
        Field[] fields = new Field[metaInfos.size()];
        int index = 0;
        for (Map.Entry<String, DataType> metaInfo : metaInfos.entrySet()) {
            fields[index] = new Field(metaInfo.getKey(), metaInfo.getValue());
            ++index;
        }
        return DataSetUtils.buildDataSet(algokey, fields, values);
    }

    private static DataSet buildDataSet(String algokey, Field[] fields, Collection<Object[]> values) {
        RowMeta rowMeta = new RowMeta(fields);
        return Algo.create((String)algokey).createDataSet(values.iterator(), rowMeta);
    }

    public static DataSet buildDataSet(Map<String, DataType> metaInfos, Collection<Object[]> values) {
        return DataSetUtils.buildDataSet("DataSetUtils.buildDataSet", metaInfos, values);
    }

    public static DataSet buildEmptyDataSet(Field[] fields) {
        ArrayList<Object[]> values = new ArrayList<Object[]>(16);
        return DataSetUtils.buildDataSet("DataSetUtils.buildDataSet", fields, values);
    }

    public static <T> Set<T> getValuesFromDataSet(DataSet ds, String field) {
        HashSet<Object> values = new HashSet<Object>(128);
        DataSet copyDataSet = ds.copy();
        for (Row row : copyDataSet) {
            values.add(row.get(field));
        }
        return values;
    }
}

