/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scmc.ism.model.mapcfg.fieldinfo.BillFieldInfo;

public class DynamicObjectUtil {
    public static boolean checkIsNotOrg(DynamicObject ... objs) {
        for (DynamicObject obj : objs) {
            if (obj == null || "bos_org".equals(obj.getDataEntityType().getName())) continue;
            return true;
        }
        return false;
    }

    public static DynamicObject buildObject(String entity, Object id) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)entity);
        obj.set("id", id);
        return obj;
    }

    public static String[] parseMultiSelectText(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return new String[0];
        }
        String[] split = text.split(",");
        ArrayList<String> values = new ArrayList<String>(split.length);
        for (String value : split) {
            if (StringUtils.isBlank((CharSequence)value)) continue;
            values.add(value);
        }
        return values.toArray(new String[values.size()]);
    }

    public static String getLastKey(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return key;
        }
        String[] splitKey = key.split("\\.");
        if (splitKey.length > 1) {
            return splitKey[splitKey.length - 1];
        }
        return key;
    }

    public static Object getValue(DynamicObject obj, String key) {
        String[] strs = key.split("\\.");
        if (strs.length == 1) {
            return obj.get(key);
        }
        if (strs.length == 2) {
            DynamicObjectCollection entryentity = obj.getDynamicObjectCollection(strs[0]);
            if (entryentity.size() > 0) {
                return ((DynamicObject)entryentity.get(0)).get(strs[1]);
            }
            return null;
        }
        return null;
    }

    public static Object getPropValue(DynamicObject obj, String key) {
        String[] sp = key.split("\\.");
        Object value = null;
        for (int i = 0; i < sp.length; ++i) {
            if (i == 0) {
                value = obj.get(sp[i]);
                continue;
            }
            if (value == null) {
                return value;
            }
            value = ((DynamicObject)value).get(sp[i]);
        }
        if (value instanceof OrmLocaleValue) {
            value = ((OrmLocaleValue)value).getLocaleValue();
        }
        return value;
    }

    public static void setValue(DynamicObject obj, String key, Object value) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        obj.set(key, value);
    }

    public static Map<String, List<DynamicObject>> getMultiFieldDynamicObjects(DynamicObject obj, String ... keys) {
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(keys.length);
        HashMap<String, ArrayList<String>> entrykeys = new HashMap<String, ArrayList<String>>(keys.length);
        for (String key : keys) {
            if (StringUtils.isEmpty((CharSequence)key)) continue;
            ArrayList<DynamicObject> values = new ArrayList<DynamicObject>();
            result.put(key, values);
            String[] strs = key.split("\\.");
            if (strs.length == 1) {
                DynamicObject value = obj.getDynamicObject(key);
                if (value == null) continue;
                values.add(obj.getDynamicObject(key));
                continue;
            }
            if (strs.length != 2) continue;
            String entryKey = strs[0];
            ArrayList<String> entryFieldKeys = (ArrayList<String>)entrykeys.get(entryKey);
            if (entryFieldKeys == null) {
                entryFieldKeys = new ArrayList<String>();
                entrykeys.put(entryKey, entryFieldKeys);
            }
            entryFieldKeys.add(strs[1]);
        }
        if (entrykeys.isEmpty()) {
            return result;
        }
        for (Map.Entry entry : entrykeys.entrySet()) {
            String key = (String)entry.getKey();
            List fieldkeys = (List)entry.getValue();
            Map<String, List<DynamicObject>> entryDynamicObjects = DynamicObjectUtil.getEntryDynamicObjects(obj, key, fieldkeys);
            result.putAll(entryDynamicObjects);
        }
        return result;
    }

    private static Map<String, List<DynamicObject>> getEntryDynamicObjects(DynamicObject obj, String entryKey, List<String> fieldkeys) {
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(fieldkeys.size());
        DynamicObjectCollection collections = obj.getDynamicObjectCollection(entryKey);
        for (DynamicObject entryObj : collections) {
            for (String entryFieldkey : fieldkeys) {
                String mapKey = entryKey + '.' + entryFieldkey;
                DynamicObject value = entryObj.getDynamicObject(entryFieldkey);
                if (value == null) continue;
                ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)result.get(mapKey);
                if (list == null) {
                    list = new ArrayList<DynamicObject>(collections.size());
                    result.put(mapKey, list);
                }
                list.add(value);
            }
        }
        return result;
    }

    public static Set<Long> getDynamicObjectIds(Collection<DynamicObject> objs) {
        return DynamicObjectUtil.getDynaObjsValue(objs, "id", Long.class);
    }

    public static <T> Set<T> getDynaObjsValue(Collection<DynamicObject> objs, String fieldKey, Class<T> clazz) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(16);
        if (objs == null) {
            return result;
        }
        for (DynamicObject obj : objs) {
            if (obj == null) continue;
            Object id = obj.get(fieldKey);
            result.add(id);
        }
        return result;
    }

    public static Map<String, List<DynamicObject>> splitListByBillType(Collection<DynamicObject> bills) {
        HashMap<String, List<DynamicObject>> relationBills = new HashMap<String, List<DynamicObject>>(4);
        for (DynamicObject singleBill : bills) {
            String billType = singleBill.getDataEntityType().getName();
            if (!relationBills.containsKey(billType)) {
                LinkedList list = new LinkedList();
                relationBills.put(billType, list);
            }
            ((List)relationBills.get(billType)).add(singleBill);
        }
        return relationBills;
    }

    public static String getCodeNumber(DynamicObject obj) {
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)obj.getDataEntityType().getName(), (DynamicObject)obj, null);
        if (codeRuleInfo != null) {
            return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)obj);
        }
        return "";
    }

    public static String[] batchGetCodeNumber(DynamicObject obj, int count) {
        return DynamicObjectUtil.batchGetCodeNumber(obj, null, count);
    }

    public static String[] batchGetCodeNumber(DynamicObject obj, String orgid, int count) {
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)obj.getDataEntityType().getName(), (DynamicObject)obj, null);
        if (codeRuleInfo != null) {
            return CodeRuleServiceHelper.getBatchNumber((String)obj.getDataEntityType().getName(), (DynamicObject)obj, (String)orgid, (int)count);
        }
        return null;
    }

    public static DynamicObject setBillId(DynamicObject bill, String entrykey) {
        long billId = bill.getLong("id");
        if (billId == 0L) {
            DynamicObjectType billtype = bill.getDynamicObjectType();
            long id = DB.genLongId((String)billtype.getAlias());
            bill.set("id", (Object)id);
        }
        DynamicObjectCollection billentries = bill.getDynamicObjectCollection(entrykey);
        DynamicObjectType entryType = billentries.getDynamicObjectType();
        long[] genLongIds = DB.genLongIds((String)entryType.getAlias(), (int)billentries.size());
        for (int i = 0; i < billentries.size(); ++i) {
            DynamicObject entry = (DynamicObject)billentries.get(i);
            long entryId = entry.getLong("id");
            if (entryId != 0L) continue;
            entry.set("id", (Object)genLongIds[i]);
        }
        return bill;
    }

    public static Long getPkValue(DynamicObject obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getLong("id");
    }

    public static Long getMaterialMasterId(DynamicObject materialObj) {
        DynamicObject masterObject = DynamicObjectUtil.getMaterialMasterObject(materialObj);
        return masterObject.getLong("id");
    }

    public static DynamicObject getMaterialMasterObject(DynamicObject valObj) {
        String materialEntity;
        switch (materialEntity = valObj.getDataEntityType().getName()) {
            case "bd_materialinventoryinfo": 
            case "bd_materialpurchaseinfo": 
            case "bd_materialsalinfo": 
            case "bd_materialmftinfo": 
            case "bd_inspect_cfg": {
                return valObj.getDynamicObject("masterid");
            }
        }
        return valObj;
    }

    public static Set<String> getItemClassType(IDataEntityProperty ... properties) {
        HashSet<String> keys = new HashSet<String>(2);
        for (IDataEntityProperty property : properties) {
            keys.add(property.getName());
            if (!(property instanceof ItemClassProp)) continue;
            keys.add(((ItemClassProp)property).getTypePropName());
        }
        return keys;
    }

    public static String getItemClasstype(IDataEntityProperty property) {
        if (property instanceof ItemClassProp) {
            IDataEntityType parent = property.getParent();
            if (parent instanceof EntryType) {
                return String.format("%s.%s", parent.getName(), ((ItemClassProp)property).getTypePropName());
            }
            return ((ItemClassProp)property).getTypePropName();
        }
        return null;
    }

    public static DynamicObject getObject(DynamicObject bill, DynamicObject entry, BillFieldInfo fieldInfo) {
        if (fieldInfo == null) {
            return null;
        }
        return (DynamicObject)fieldInfo.getValue(bill, entry);
    }
}

