/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.utils;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.ism.lang.CommonLang;

public class OperationUtil {
    public static OperateOption getBackCallsOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("backwriteoff_tag", String.valueOf(true));
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("isIgnoreVirualBillValidate", String.valueOf(true));
        option.setVariableValue("ismoperate", String.valueOf(true));
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("ignorewarn", String.valueOf(true));
        return option;
    }

    public static OperateOption getBackCallsNoMutexOption() {
        OperateOption option = OperationUtil.getBackCallsOption();
        option.setVariableValue("ignoreValidation", String.valueOf(true));
        return option;
    }

    public static OperationResult invokeOperation(DynamicObject obj, String operation) throws KDBizException {
        return OperationUtil.invokeOperation(new DynamicObject[]{obj}, operation);
    }

    public static OperationResult invokeOperation(DynamicObject[] objs, String operation, OperateOption option) throws KDBizException {
        if (objs == null || objs.length == 0) {
            throw new KDBizException(CommonLang.dataNullOperateFaill());
        }
        if (option == null) {
            option = OperateOption.create();
            option.setVariableValue("", "");
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)operation, (String)objs[0].getDataEntityType().getName(), (DynamicObject[])objs, (OperateOption)option);
        OperationUtil.checkIsSuccess(result, operation);
        return result;
    }

    public static OperationResult invokeOperationById(String entityName, Object[] ids, String operation, OperateOption option) throws KDBizException {
        if (ids == null || ids.length == 0) {
            throw new KDBizException(CommonLang.dataNullOperateFaill());
        }
        if (option == null) {
            option = OperateOption.create();
            option.setVariableValue("", "");
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)operation, (String)entityName, (Object[])ids, (OperateOption)option);
        OperationUtil.checkIsSuccess(result, operation);
        return result;
    }

    private static void checkIsSuccess(OperationResult result, String operation) {
        if (!result.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            sb.append(CommonLang.callOperateFail(operation, result));
            sb.append(" - ");
            List validResultList = result.getValidateResult().getValidateErrors();
            for (ValidateResult validation : validResultList) {
                List allErrorInfo = validation.getAllErrorInfo();
                for (OperateErrorInfo info : allErrorInfo) {
                    sb.append(info.getMessage());
                    sb.append(',');
                }
            }
            throw new KDBizException(sb.toString());
        }
    }

    public static OperationResult invokeOperation(DynamicObject[] objs, String operation) throws KDBizException {
        return OperationUtil.invokeOperation(objs, operation, OperateOption.create());
    }
}

