/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.utils.control;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.control.FilterGrid;
import kd.bos.orm.query.QFilter;
import kd.scmc.ism.business.helper.filter.CommonFilterHelper;

public class FilterGridUtils {
    public static void setFilterControlType(FilterGrid filterGrid, String entityNumber) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        GetFilterFieldsParameter para = new GetFilterFieldsParameter((IDataEntityType)mainEntityType);
        para.setOnlyMainEntityField(true);
        para.setbCompatibleProductMode(false);
        para.setNeedAliasEmptyFieldProp(false);
        List createFilterColumns = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)para);
        FilterGridUtils.removeIllegalFiled(mainEntityType, createFilterColumns);
        filterGrid.setEntityNumber(mainEntityType.getName());
        filterGrid.setFilterColumns(createFilterColumns);
    }

    private static void removeIllegalFiled(MainEntityType mainEntityType, List<Map<String, Object>> createFilterColumns) {
        Map<String, Set<String>> removeProps = FilterGridUtils.getEntityBaseDataEntryFiled(mainEntityType);
        Iterator<Map<String, Object>> iterator = createFilterColumns.iterator();
        while (iterator.hasNext()) {
            Set<String> removePropSet;
            Map<String, Object> map = iterator.next();
            String entityId = (String)map.get("entityId");
            if (entityId == null) continue;
            String filedName = (String)map.get("fieldName");
            String[] split = filedName.split("\\.");
            if (split.length >= 3) {
                iterator.remove();
                continue;
            }
            if (split.length <= 1 || (removePropSet = removeProps.get(entityId)) == null || !removePropSet.contains(split[1])) continue;
            iterator.remove();
        }
    }

    private static Map<String, Set<String>> getEntityBaseDataEntryFiled(MainEntityType mainEntityType) {
        HashMap<String, Set<String>> removeProps = new HashMap<String, Set<String>>();
        for (IDataEntityProperty fieldProp : mainEntityType.getAllFields().values()) {
            String baseEntityId;
            if (!(fieldProp instanceof BasedataProp) || fieldProp.getParent() != mainEntityType || removeProps.containsKey(baseEntityId = ((BasedataProp)fieldProp).getBaseEntityId()) || baseEntityId == null) continue;
            HashSet<String> removeEntity = new HashSet<String>(16);
            BasedataEntityType baseDataEntity = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityId);
            for (EntityType entityType : baseDataEntity.getAllEntities().values()) {
                if (!(entityType instanceof EntryType)) continue;
                DataEntityPropertyCollection values = ((EntryType)entityType).getProperties();
                for (IDataEntityProperty entryProp : values) {
                    removeEntity.add(entryProp.getName());
                }
            }
            removeProps.put(baseEntityId, removeEntity);
        }
        return removeProps;
    }

    public static void setFilterControlValue(FilterGrid filterGrid, String filterText) {
        FilterCondition filterCondition = null;
        filterCondition = StringUtils.isNotEmpty((CharSequence)filterText) ? (FilterCondition)SerializationUtils.fromJsonString((String)filterText, FilterCondition.class) : new FilterCondition();
        filterGrid.SetValue(filterCondition);
    }

    public static String getFilterTextByControl(FilterGrid filterGrid) {
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        return filterString;
    }

    public static QFilter filterTextToQfilter(String billtype, String filterText) {
        if (StringUtils.isEmpty((CharSequence)filterText)) {
            return CommonFilterHelper.getAllFilter();
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterText, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billtype), condition);
        fb.buildFilter();
        return fb.getQFilter();
    }

    public static BOSExpression filterTextToExpression(String billtype, String filterText) {
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterText, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billtype), condition);
        String[] script = fb.buildFilterScript();
        return new BOSExpression(script[0]);
    }

    public static BOSExpression filterTextToExpressionByAudit(String billtype, String filterText) {
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterText, FilterCondition.class);
        List filterRow = condition.getFilterRow();
        for (SimpleFilterRow row : filterRow) {
            String fieldName = row.getFieldName();
            if (!"billstatus".equals(fieldName)) continue;
            row.setCompareType("12");
            FilterValue value = new FilterValue();
            value.setValue((Object)"C");
            row.setValue(Collections.singletonList(value));
        }
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billtype), condition);
        String[] script = fb.buildFilterScript();
        return new BOSExpression(script[0]);
    }

    public static Map<String, Object> getValueFromBillHeadObj(Collection<String> params, DynamicObject billHeadObj) {
        HashMap<String, Object> paramValues = new HashMap<String, Object>();
        BillEntityType entityType = (BillEntityType)billHeadObj.getDataEntityType();
        for (String param : params) {
            DynamicObject curObj;
            String[] splitProps = param.split("\\.");
            String propKey = splitProps[0];
            IDataEntityProperty prop = entityType.findProperty(propKey);
            IDataEntityType parentType = prop.getParent();
            if (parentType instanceof EntryType) {
                DynamicObjectCollection entry = billHeadObj.getDynamicObjectCollection(parentType.getName());
                if (entry.isEmpty()) {
                    paramValues.put(param, null);
                    continue;
                }
                curObj = (DynamicObject)entry.get(0);
            } else {
                curObj = billHeadObj;
            }
            paramValues.put(param, FilterGridUtils.getValue(splitProps, curObj));
        }
        return paramValues;
    }

    private static Object getValue(String[] splitProps, DynamicObject obj) {
        if (obj != null) {
            DynamicObject curObj = obj;
            for (int i = 0; i < splitProps.length; ++i) {
                String slitProp = splitProps[i];
                if (curObj == null) {
                    return null;
                }
                if (i + 1 == splitProps.length) {
                    return curObj.get(slitProp);
                }
                curObj = curObj.getDynamicObject(slitProp);
            }
        }
        return null;
    }
}

