/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.config;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.scmc.ism.common.consts.enums.CurrencySrcEnum;
import kd.scmc.ism.common.consts.enums.SettlePriceSrcEnum;
import kd.scmc.ism.common.consts.enums.TaxSrcEnum;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.formplugin.template.AbstractISMBaseFormPlugin;

public class InterOrgSettleRuleEdit
extends AbstractISMBaseFormPlugin
implements BeforeF7SelectListener {
    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CommonUtils.collectionIsNotEmpty(entryEntity)) {
            Object entryCurValue = ((DynamicObject)entryEntity.get(0)).get("currencysource");
            this.getModel().getDataEntity().set("currencysrc", entryCurValue);
        }
    }

    public void afterBindData(EventObject e) {
        Long value;
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                String settleSrc = ((DynamicObject)entryEntity.get(i)).getString("settlesource");
                if (!StringUtils.isNotBlank((CharSequence)settleSrc)) continue;
                this.getView().setEnable(Boolean.valueOf(settleSrc.contains(SettlePriceSrcEnum.PLUGIN_CUSTOM.getValue())), i, new String[]{"custompriceplugin"});
                this.getView().setEnable(Boolean.valueOf(settleSrc.contains(SettlePriceSrcEnum.SPECIFY.getValue())), i, new String[]{"price"});
            }
        }
        if ((value = (Long)this.getModel().getValue("id")) != null && value != 0L) {
            this.getModel().setValue("currencysrc", this.getModel().getValue("currencysource"), 0);
            this.getModel().setDataChanged(false);
        }
        this.change4SrcCurrency((String)this.getModel().getValue("currencysrc"));
        this.change4Currency((DynamicObject)this.getModel().getValue("currency"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int row = changeSet[0].getRowIndex();
        switch (key) {
            case "settlesource": {
                this.change4SrcPrice(newValue, row);
                break;
            }
            case "currencysrc": {
                int rows = this.getModel().getEntryRowCount("entryentity");
                for (int i = 0; i < rows; ++i) {
                    this.getModel().setValue("currencysource", this.getModel().getValue("currencysrc"), i);
                }
                this.change4SrcCurrency((String)newValue);
                break;
            }
            case "currency": {
                this.change4Currency((DynamicObject)newValue);
                break;
            }
            case "taxsource": {
                String taxSrc = (String)newValue;
                boolean isSpecify = StringUtils.isNotBlank((CharSequence)taxSrc) && taxSrc.contains(TaxSrcEnum.SPECIFY.getValue());
                this.getView().setEnable(Boolean.valueOf(isSpecify), row, new String[]{"taxrate"});
                if (isSpecify) break;
                this.getModel().setValue("taxrate", (Object)null, row);
            }
        }
    }

    private void change4SrcPrice(Object newValue, int row) {
        String settleSrc = (String)newValue;
        boolean isPluginCustom = StringUtils.isNotBlank((CharSequence)settleSrc) && settleSrc.contains(SettlePriceSrcEnum.PLUGIN_CUSTOM.getValue());
        this.getView().setEnable(Boolean.valueOf(isPluginCustom), row, new String[]{"custompriceplugin"});
        if (!isPluginCustom) {
            this.getModel().setValue("custompriceplugin", null, row);
        }
        boolean isSpecify = StringUtils.isNotBlank((CharSequence)settleSrc) && settleSrc.contains(SettlePriceSrcEnum.SPECIFY.getValue());
        this.getView().setEnable(Boolean.valueOf(isSpecify), row, new String[]{"price"});
        if (!isSpecify) {
            this.getModel().setValue("price", null, row);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("newentry".equals(key)) {
            int rows = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < rows; ++i) {
                this.getModel().setValue("currencysource", this.getModel().getValue("currencysrc"), i);
                this.getModel().setValue("currencyinfo", this.getModel().getValue("currency"), i);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        DynamicObjectCollection entryEntity;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("newentry".equals(itemKey) && (entryEntity = this.getModel().getEntryEntity("entryentity")) != null) {
            this.getView().setEnable(Boolean.FALSE, entryEntity.size() - 1, new String[]{"custompriceplugin", "price"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, "supplier", "demand");
    }

    private void change4SrcCurrency(String currencySrc) {
        boolean isSpecify;
        boolean bl = isSpecify = StringUtils.isNotBlank((CharSequence)currencySrc) && currencySrc.contains(CurrencySrcEnum.SPECIFY.getValue());
        if (!isSpecify) {
            this.getModel().setValue("currency", (Object)null);
        }
        this.getView().setVisible(Boolean.valueOf(isSpecify), new String[]{"currency"});
        this.getView().setVisible(Boolean.valueOf(isSpecify), new String[]{"currencyinfo"});
    }

    private void change4Currency(DynamicObject currency) {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue("currencyinfo", (Object)currency, i);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String property;
        switch (property = e.getProperty().getName()) {
            case "demand": {
                this.beforeSelectDemand(e);
                break;
            }
            case "supplier": {
                this.beforeSelectSupplier(e);
                break;
            }
        }
    }

    private void beforeSelectSupplier(BeforeF7SelectEvent e) {
        DynamicObject demand = (DynamicObject)this.getModel().getValue("demand");
        if (demand == null) {
            return;
        }
        QFilter filter = new QFilter("id", "!=", (Object)DynamicObjectUtil.getPkValue(demand));
        e.addCustomQFilter(filter);
    }

    private void beforeSelectDemand(BeforeF7SelectEvent e) {
        DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
        if (supplier == null) {
            return;
        }
        QFilter filter = new QFilter("id", "!=", (Object)DynamicObjectUtil.getPkValue(supplier));
        e.addCustomQFilter(filter);
    }
}

