/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.config;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.business.selectlistener.billmainentity.BillEnableBFM;
import kd.scmc.ism.business.utils.ColsTreeUtil;
import kd.scmc.ism.common.selectstrategy.BaseDataTypeStrategy;
import kd.scmc.ism.common.selectstrategy.OrgColStrategy;
import kd.scmc.ism.common.selectstrategy.SimpleStrategy;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.MultiLangUtils;
import kd.scmc.ism.common.utils.control.FilterGridUtils;
import kd.scmc.ism.formplugin.template.AbstractISMBaseFormPlugin;
import kd.scmc.ism.lang.FormLang;

public class SettleBillJudgementEdit
extends AbstractISMBaseFormPlugin {
    private static final String FILTERGRIDAP = "filtergridap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(BillEnableBFM.getInstance(), "bill");
        this.addClickListeners(new String[]{"balanceorgname", "ownerorgname", "settlerelationname"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "balanceorgname": 
            case "ownerorgname": 
            case "settlerelationname": {
                this.doClick(evt, key);
                break;
            }
        }
    }

    private void doClick(EventObject evt, String key) {
        DynamicObject currentEntity = this.getModel().getDataEntity().getDynamicObject("bill");
        if (currentEntity == null) {
            return;
        }
        String entityNumber = currentEntity.getString("number");
        SimpleStrategy strategy = null;
        switch (key) {
            case "balanceorgname": 
            case "ownerorgname": {
                strategy = new OrgColStrategy();
                break;
            }
            case "settlerelationname": {
                strategy = new BaseDataTypeStrategy("ism_settlerelations");
                break;
            }
        }
        IDataEntityProperty property = ((BasedataEntityType)this.getModel().getDataEntityType()).findProperty(key);
        String localeValue = property.getDisplayName().getLocaleValue();
        String pageName = FormLang.plsSelectField(localeValue);
        PageShowHelper.showSelectColsPage(this.getView(), entityNumber, strategy, pageName, new CloseCallBack((IFormPlugin)this, key));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String sourceFldKey;
        switch (sourceFldKey = closedCallBackEvent.getActionId()) {
            case "balanceorgname": {
                this.selectColsPageCloseCallBack("balanceorg", "balanceorgname", closedCallBackEvent);
                break;
            }
            case "ownerorgname": {
                this.selectColsPageCloseCallBack("ownerorg", "ownerorgname", closedCallBackEvent);
                break;
            }
            case "settlerelationname": {
                this.selectColsPageCloseCallBack("settlerelation", "settlerelationname", closedCallBackEvent);
                break;
            }
        }
    }

    private void selectColsPageCloseCallBack(String fieldKey, String fieldNameKey, ClosedCallBackEvent closedCallBackEvent) {
        JSONArray data = ColsTreeUtil.parseReturnData(closedCallBackEvent);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject jsonObject = data.getJSONObject(0);
        Object sourceFiledKey = jsonObject.get((Object)"id");
        Object sourceFiledName = jsonObject.get((Object)"text");
        boolean validateReturnData = this.validateReturnData(fieldKey, sourceFiledKey.toString());
        if (!validateReturnData) {
            this.getView().showTipNotification(FormLang.noMatchSelectField());
            return;
        }
        IDataModel model = this.getModel();
        model.setValue(fieldKey, sourceFiledKey);
        model.setValue(fieldNameKey, sourceFiledName);
    }

    private boolean validateReturnData(String field, String fieldValue) {
        IDataModel model = this.getModel();
        DynamicObject bill = (DynamicObject)model.getValue("bill");
        String entityName = bill.getString("number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        IDataEntityProperty property = entityType.findProperty(DynamicObjectUtil.getLastKey(fieldValue));
        return property instanceof BasedataProp;
    }

    private void setFieldKeyContent() {
        DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
        if (bill == null) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)bill.getString("number"));
        this.transLangSetValue(dt, "balanceorg", "balanceorgname");
        this.transLangSetValue(dt, "ownerorg", "ownerorgname");
        this.transLangSetValue(dt, "settlerelation", "settlerelationname");
        this.getModel().setDataChanged(false);
    }

    private void transLangSetValue(MainEntityType dt, String keyFieldName, String transKeyFieldName) {
        String value = (String)this.getModel().getValue(keyFieldName);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return;
        }
        Map<String, String> field = MultiLangUtils.getEntityKey(dt, value);
        if (CommonUtils.mapIsEmpty(field)) {
            return;
        }
        String transLang = field.values().iterator().next();
        this.getModel().setValue(transKeyFieldName, (Object)transLang);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setFieldKeyContent();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setFieldKeyContent();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFilterGridFromText();
        this.presetdata("ispreset", "presetdatatipflex", "flexpanelap3", "bar_save");
    }

    private void setFilterGridFromText() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        DynamicObject currentEntity = this.getModel().getDataEntity().getDynamicObject("bill");
        if (currentEntity != null) {
            String entityNumber = currentEntity.getString("number");
            FilterGridUtils.setFilterControlType(filterGrid, entityNumber);
            String billfilterstr = (String)this.getModel().getDataEntity().get("billfilterstr_tag");
            if (StringUtils.isNotBlank((CharSequence)billfilterstr)) {
                FilterGridUtils.setFilterControlValue(filterGrid, billfilterstr);
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{FILTERGRIDAP, "balanceorgname", "ownerorgname", "settlerelationname"});
        } else {
            FilterGridUtils.setFilterControlValue(filterGrid, null);
            this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP, "balanceorgname", "ownerorgname", "settlerelationname"});
        }
        this.getView().updateView(FILTERGRIDAP);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "bill": {
                this.changeBill(e);
                break;
            }
            case "balanceorgname": {
                this.clearFieldByChange(e, "balanceorg");
                break;
            }
            case "ownerorgname": {
                this.clearFieldByChange(e, "ownerorg");
                break;
            }
            case "settlerelationname": {
                this.clearFieldByChange(e, "settlerelation");
            }
        }
    }

    private void clearFieldByChange(PropertyChangedArgs e, String fieldkey) {
        ChangeData[] datas;
        for (ChangeData changeData : datas = e.getChangeSet()) {
            String newValue = (String)changeData.getNewValue();
            if (!StringUtils.isEmpty((CharSequence)newValue)) continue;
            this.getModel().setValue(fieldkey, null);
        }
    }

    private void changeBill(PropertyChangedArgs e) {
        this.getModel().setValue("balanceorgname", null);
        this.getModel().setValue("balanceorg", null);
        this.getModel().setValue("ownerorg", null);
        this.getModel().setValue("ownerorgname", null);
        this.getModel().setValue("settlerelation", null);
        this.getModel().setValue("settlerelationname", null);
        DynamicObject bill = (DynamicObject)this.getModel().getValue("bill");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        filterGrid.SetValue(new FilterCondition());
        if (bill != null) {
            String entityNumber = bill.getString("number");
            FilterGridUtils.setFilterControlType(filterGrid, entityNumber);
            this.getView().setEnable(Boolean.TRUE, new String[]{FILTERGRIDAP, "balanceorgname", "ownerorgname", "settlerelationname"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP, "balanceorgname", "ownerorgname", "settlerelationname"});
        }
        this.getView().updateView(FILTERGRIDAP);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key)) {
            this.beforeSave();
        }
    }

    private void beforeSave() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        String filterString = FilterGridUtils.getFilterTextByControl(filterGrid);
        this.getModel().setValue("billfilterstr_tag", (Object)filterString);
    }
}

