/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.config;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.helper.BizFlowServiceHelper;
import kd.scmc.ism.business.helper.BizFlowShowHelper;
import kd.scmc.ism.business.helper.BotpPushHepler;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.formplugin.template.AbstractISMBaseFormPlugin;
import kd.scmc.ism.lang.FormLang;
import kd.scmc.ism.lang.ModelLang;

public class SettleLogEdit
extends AbstractISMBaseFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        ((EntryGrid)this.getControl("entryentity")).addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BotpPushHepler.showConvertRuleEdit(this.getView(), "botpid");
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName;
        switch (fieldName = e.getFieldName()) {
            case "settlebillno": {
                this.showBill(e.getRowIndex());
                break;
            }
            case "bizflow": {
                this.showBizFlowViewChart(e.getRowIndex());
                break;
            }
        }
    }

    private void showBizFlowViewChart(int rowIndex) {
        DynamicObject singleEntry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        Long id = singleEntry.getLong("settlebillid");
        String type = singleEntry.getDynamicObject("settlebilltype").getString("number");
        DynamicObject bizFlowObj = singleEntry.getDynamicObject("bizflow");
        if (bizFlowObj != null) {
            String bizFlowKey;
            String billIdstr = String.valueOf(id);
            if (BizFlowServiceHelper.isFinishedBizFlow(billIdstr, bizFlowKey = bizFlowObj.getString("key")) || BizFlowServiceHelper.isRunningBizFlow(billIdstr, bizFlowKey)) {
                BizFlowShowHelper.showBizFlowViewChart(this.getView(), type, id, bizFlowObj.getLong("id"));
            } else {
                throw new KDBizException(ModelLang.bizFlowNotRunning());
            }
        }
    }

    private void showBill(int row) {
        DynamicObject singleEntry = this.getModel().getEntryRowEntity("entryentity", row);
        Long id = singleEntry.getLong("settlebillid");
        String type = singleEntry.getDynamicObject("settlebilltype").getString("number");
        if (QueryServiceHelper.exists((String)type, (Object)id)) {
            PageShowHelper.showBillEdit(this.getView(), type, (Object)id);
        } else {
            this.getView().showTipNotification(FormLang.curBillNotExist());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperateKey().equals("logupdate")) {
            this.getView().invokeOperation("refresh");
        }
    }
}

