/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.config;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.helper.BizFlowServiceHelper;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.business.helper.filter.CommonF7SelectFilterHelper;
import kd.scmc.ism.common.consts.config.SettleLogConsts;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.lang.FormLang;

public class SettleLogListEdit
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("checkjoblog".equals(itemKey)) {
            this.checkTask();
        } else if ("checkjoberrolog".equals(itemKey)) {
            this.checkErroTask();
        } else if ("chekchistbizflow".equals(itemKey)) {
            this.checkHistBizFlow();
        } else if ("checkexecutionflow".equals(itemKey)) {
            this.checkExecutionFlow();
        } else if ("checkerroflow".equals(itemKey)) {
            this.checkErroFlow();
        } else if ("checkjoberroinglog".equals(itemKey)) {
            this.checkErroingTaskLog();
        }
    }

    private void checkErroFlow() {
        DynamicObjectCollection settleLogInfos = this.getSelectedLogInfo();
        ArrayList<String> settleBillIds = new ArrayList<String>(settleLogInfos.size());
        for (DynamicObject logInfo : settleLogInfos) {
            settleBillIds.add(logInfo.getString("settlebillid"));
        }
        ListShowParameter param = PageShowHelper.getBaseDataListParam("wf_deadletterjob", new QFilter("businesskey", "in", settleBillIds));
        param.setAppId("057C+RJ/1S7U");
        this.getView().showForm((FormShowParameter)param);
    }

    private void checkHistBizFlow() {
        ListShowParameter param = PageShowHelper.getBaseDataListParam("bpm_historicalprocess", new QFilter("businesskey", "in", this.getSelectedVBillIds()));
        param.setAppId("057C+RJ/1S7U");
        this.getView().showForm((FormShowParameter)param);
    }

    private void checkExecutionFlow() {
        DynamicObjectCollection settleLogInfos = this.getSelectedLogInfo();
        ArrayList<String> settleBillIds = new ArrayList<String>(settleLogInfos.size());
        ArrayList<String> biztracenos = new ArrayList<String>(settleLogInfos.size());
        for (DynamicObject logInfo : settleLogInfos) {
            biztracenos.add(logInfo.getString("biztraceno"));
            settleBillIds.add(logInfo.getString("settlebillno"));
        }
        ListShowParameter param = PageShowHelper.getBaseDataListParam("wf_execution_tree", new QFilter("billno", "in", settleBillIds).and("biztraceno", "in", biztracenos));
        param.setAppId("057C+RJ/1S7U");
        this.getView().showForm((FormShowParameter)param);
    }

    private void checkTask() {
        this.getView().showForm((FormShowParameter)PageShowHelper.getBaseDataListParam("sch_task", new QFilter("job", "in", this.getSelectedVBillIds())));
    }

    private void checkErroTask() {
        this.getView().showForm((FormShowParameter)PageShowHelper.getBaseDataListParam("sch_errorjob", new QFilter("fjobid", "in", this.getSelectedVBillIds())));
    }

    private void checkErroingTaskLog() {
        List<String> vBillIds = this.getSelectedVBillIds();
        ArrayList<String> finOrRunBillIds = new ArrayList<String>(16);
        finOrRunBillIds.addAll(BizFlowServiceHelper.getRunningBizFlowByBillIds(vBillIds));
        finOrRunBillIds.addAll(BizFlowServiceHelper.getFinishedBizFlowByBillIds(vBillIds));
        vBillIds.removeAll(finOrRunBillIds);
        this.getView().showForm((FormShowParameter)PageShowHelper.getBaseDataListParam("sch_errorjob", new QFilter("fjobid", "in", vBillIds)));
    }

    private List<String> getSelectedVBillIds() {
        DynamicObjectCollection settleLogInfos = this.getSelectedLogInfo();
        ArrayList<String> settleBillIds = new ArrayList<String>(settleLogInfos.size());
        for (DynamicObject logInfo : settleLogInfos) {
            settleBillIds.add(String.valueOf(logInfo.getLong("settlebillid")));
        }
        return settleBillIds;
    }

    private DynamicObjectCollection getSelectedLogInfo() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            throw new KDBizException(FormLang.plsSelectData());
        }
        HashSet<Long> ids = new HashSet<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        DynamicObjectCollection settleLogInfos = QueryServiceHelper.query((String)"ism_settlelog", (String)("biztraceno," + SettleLogConsts.buildEntryFields("settlebillid", "settlebillno")), (QFilter[])new QFilter("id", "in", ids).toArray());
        return settleLogInfos;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (operateKey.equals("logupdate")) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List columns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : columns) {
            if (!"sourcetype.name".equals(filterColumn.getFieldName())) continue;
            DynamicObjectCollection judgements = QueryServiceHelper.query((String)"bos_billmainentity", (String)"id,name", (QFilter[])CommonF7SelectFilterHelper.getSettleJudgeBillTypeFilter().toArray());
            List<ComboItem> combos = FormUtils.getComboItemFromObj(judgements, "name", "id");
            CommonFilterColumn orgColumn = (CommonFilterColumn)filterColumn;
            orgColumn.setComboItems(combos);
            orgColumn.setType("enum");
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("sourcetype.id".equals(args.getFieldName())) {
            args.addCustomQFilter(CommonF7SelectFilterHelper.getSettleJudgeBillTypeFilter());
        }
    }
}

