/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.scmc.ism.business.helper.InputConstsHelper;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.common.consts.config.settleparam.CommonParamField;
import kd.scmc.ism.common.consts.config.settleparam.DemandParamField;
import kd.scmc.ism.common.consts.config.settleparam.ISettleParamField;
import kd.scmc.ism.common.consts.config.settleparam.SupplierParamField;
import kd.scmc.ism.common.model.args.InputConstsResult;
import kd.scmc.ism.common.selectstrategy.ExcludeFieldStrategy;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.formplugin.template.AbstractISMBaseFormPlugin;
import kd.scmc.ism.lang.FormLang;
import org.apache.commons.lang.StringUtils;

public class SettleParamEdit
extends AbstractISMBaseFormPlugin {
    private static final ISettleParamField[] paramFields = new ISettleParamField[]{CommonParamField.getInstance(), SupplierParamField.getInstance(), DemandParamField.getInstance()};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener("demand");
        for (ISettleParamField settleParamField : paramFields) {
            this.addClickListeners(new String[]{settleParamField.targetFieldName(), settleParamField.constantsDescKey()});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.dealRuleData();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.dealRuleData();
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.dealRuleData();
    }

    private void dealRuleData() {
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("datainfo");
        ArrayList<DynamicObject> commons = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> suppliers = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> demands = new ArrayList<DynamicObject>(16);
        for (DynamicObject entry : entryList) {
            String hihnTab = entry.getString("columntype");
            if ("com".equals(hihnTab)) {
                commons.add(entry);
                continue;
            }
            if ("sup".equals(hihnTab)) {
                suppliers.add(entry);
                continue;
            }
            if (!"dem".equals(hihnTab)) continue;
            demands.add(entry);
        }
        this.initRuleData(commons, CommonParamField.getInstance());
        this.initRuleData(suppliers, SupplierParamField.getInstance());
        this.initRuleData(demands, DemandParamField.getInstance());
        this.getModel().setDataChanged(false);
    }

    private void initRuleData(List<DynamicObject> entries, ISettleParamField settleParamField) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"ism_billmapcfg");
        DynamicObjectCollection entryList = this.getModel().getEntryEntity(settleParamField.entryKey());
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject dataInfo = entries.get(i);
            DynamicObject entryInfo = entryList.addNew();
            entryInfo.set("seq", (Object)(i + 1));
            String targetKey = dataInfo.getString("targetfieldkey");
            entryInfo.set("id", (Object)targetKey);
            entryInfo.set(settleParamField.targetFieldKey(), (Object)targetKey);
            entryInfo.set(settleParamField.targetFieldName(), (Object)dataInfo.getString("targetfieldname"));
            entryInfo.set(settleParamField.valueType(), (Object)dataInfo.getString("valuetype"));
            entryInfo.set(settleParamField.constantsKey(), (Object)dataInfo.getString("constants"));
            entryInfo.set(settleParamField.constantsTagKey(), (Object)dataInfo.getString("constants_tag"));
            entryInfo.set(settleParamField.constantsDescKey(), (Object)dataInfo.getString("constantsdesc"));
            IDataEntityProperty property = mainEntityType.findProperty(targetKey);
            boolean canCondtion = property instanceof BasedataProp || property instanceof ComboProp;
            this.getView().setEnable(Boolean.valueOf(canCondtion), i, new String[]{settleParamField.valueType()});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getModel().setDataChanged(true);
        String key = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ("supplier".equals(key)) {
            this.getModel().setValue("demand", null);
        } else {
            for (ISettleParamField settleParamField : paramFields) {
                if (key.equals(settleParamField.targetFieldName())) {
                    this.targetFieldNameChanged(settleParamField, rowIndex);
                    continue;
                }
                if (key.equals(settleParamField.constantsDescKey())) {
                    this.constantChanged(settleParamField, rowIndex);
                    continue;
                }
                if (!key.equals(settleParamField.valueType())) continue;
                this.valueTypeChanged(settleParamField, rowIndex);
            }
        }
    }

    private void targetFieldNameChanged(ISettleParamField settleParamField, int rowIndex) {
        IDataModel model = this.getModel();
        String value = (String)model.getValue(settleParamField.targetFieldName());
        if (StringUtils.isEmpty((String)value)) {
            model.setValue(settleParamField.targetFieldKey(), null, rowIndex);
        }
        model.setValue(settleParamField.constantsDescKey(), null, rowIndex);
    }

    private void valueTypeChanged(ISettleParamField settleParamField, int rowIndex) {
        this.getModel().setValue(settleParamField.constantsDescKey(), null, rowIndex);
    }

    private void constantChanged(ISettleParamField settleParamField, int rowIndex) {
        this.getModel().setValue(settleParamField.constantsKey(), null, rowIndex);
        this.getModel().setValue(settleParamField.constantsTagKey(), null, rowIndex);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        for (ISettleParamField settleParamField : paramFields) {
            if (key.equals(settleParamField.targetFieldName())) {
                this.clickTagFieldNameText(settleParamField);
                continue;
            }
            if (!key.equals(settleParamField.constantsDescKey())) continue;
            this.clickConstantsText(settleParamField);
        }
    }

    private void clickTagFieldNameText(ISettleParamField settleParamField) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(settleParamField.entryKey());
        HashSet<String> names = new HashSet<String>(16);
        if (entries != null) {
            for (DynamicObject entry : entries) {
                String dimKey = entry.getString(settleParamField.targetFieldKey());
                if (!StringUtils.isNotEmpty((String)dimKey)) continue;
                names.add(dimKey);
            }
        }
        names.add("mainbizorg");
        names.add("billentry");
        names.add("number");
        names.add("status");
        names.add("material");
        names.add("unit");
        names.add("qty");
        names.add("quotation");
        names.add("basecurrency");
        names.add("settlecy");
        names.add("exratetable");
        names.add("exratedate");
        names.add("exchangerate");
        names.add("price");
        names.add("priceandtax");
        names.add("taxrate");
        names.add("taxrateid");
        names.add("taxamount");
        names.add("amount");
        names.add("amountandtax");
        names.add("discountamount");
        names.add("discountrate");
        names.add("srcbillid");
        names.add("srcbillentity");
        names.add("srcbillentryid");
        names.add("mainbillid");
        names.add("mainbillentity");
        names.add("mainbillentryid");
        names.add("groupnumber");
        names.add("groupseq");
        names.add("createtime");
        names.add("creator");
        names.add("auditdate");
        names.add("auditor");
        names.add("modifytime");
        names.add("modifier");
        PageShowHelper.showSelectColsPage(this.getView(), "ism_billmapcfg", new ExcludeFieldStrategy(names), FormLang.plsSelectTagFieldName(), new CloseCallBack((IFormPlugin)this, settleParamField.tagFieldNameCB()));
    }

    private void clickConstantsText(ISettleParamField settleParamField) {
        String valueType;
        int index = this.getModel().getEntryCurrentRowIndex(settleParamField.entryKey());
        switch (valueType = (String)this.getValue(settleParamField.valueType(), index)) {
            case "e": {
                this.showConsts(settleParamField, index);
                break;
            }
            case "c": {
                this.showCondtion(settleParamField, index);
                break;
            }
        }
    }

    private void showCondtion(ISettleParamField settleParamField, int index) {
        String tagFieldKey = (String)this.getValue(settleParamField.targetFieldKey(), index);
        if (StringUtils.isEmpty((String)tagFieldKey)) {
            this.getView().showTipNotification(FormLang.conditonDimIsEmpty());
            return;
        }
        String formula = (String)this.getModel().getValue(settleParamField.constantsKey() + "_tag", index);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ism_billmapcfg");
        IDataEntityProperty prop = entityType.findProperty(tagFieldKey);
        InputConstsHelper.showConditionVal(this, prop, settleParamField.constantsCB(), formula);
    }

    private void showConsts(ISettleParamField settleParamField, int index) {
        String tagFieldKey = (String)this.getModel().getValue(settleParamField.targetFieldKey(), index);
        if (StringUtils.isEmpty((String)tagFieldKey)) {
            this.getView().showTipNotification(FormLang.conditonDimIsEmpty());
            return;
        }
        String srcValue = (String)this.getModel().getValue(settleParamField.constantsKey() + "_tag", index);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ism_billmapcfg");
        IDataEntityProperty prop = entityType.findProperty(tagFieldKey);
        InputConstsHelper.showInputConsts((IFormPlugin)this, this.getView(), prop, settleParamField.constantsCB(), srcValue);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        InputConstsResult inputConstsResult = InputConstsHelper.getInputConstsResult(e);
        if (inputConstsResult != null) {
            actionId = inputConstsResult.getCloseCallBackId();
        }
        for (ISettleParamField settleParamField : paramFields) {
            if (actionId.equals(settleParamField.tagFieldNameCB())) {
                this.tagFieldNameCloseCallBack((String)e.getReturnData(), settleParamField);
                continue;
            }
            if (inputConstsResult == null || !actionId.equals(settleParamField.constantsCB())) continue;
            this.setConstValue(inputConstsResult.getConstsDes(), inputConstsResult.getConsts(), settleParamField);
        }
    }

    private void tagFieldNameCloseCallBack(String returnData, ISettleParamField settleParamField) {
        IDataModel model = this.getModel();
        if (StringUtils.isNotEmpty((String)returnData)) {
            JSONArray array = JSON.parseArray((String)returnData);
            if (array == null || array.isEmpty()) {
                return;
            }
            JSONObject jsonObject = array.getJSONObject(0);
            int index = model.getEntryCurrentRowIndex(settleParamField.entryKey());
            String targetKey = jsonObject.getString("id");
            model.setValue(settleParamField.targetFieldKey(), (Object)targetKey, index);
            model.setValue(settleParamField.targetFieldName(), (Object)jsonObject.getString("text"), index);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"ism_billmapcfg");
            IDataEntityProperty property = mainEntityType.findProperty(targetKey);
            String valueType = settleParamField.valueType();
            if (property instanceof BasedataProp || property instanceof ComboProp) {
                this.getView().setEnable(Boolean.TRUE, index, new String[]{valueType});
            } else {
                model.setValue(valueType, (Object)"e", index);
                this.getView().setEnable(Boolean.FALSE, index, new String[]{valueType});
            }
        }
    }

    private void setConstValue(String constsDesc, String consts, ISettleParamField settleParamField) {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex(settleParamField.entryKey());
        model.setValue(settleParamField.constantsDescKey(), (Object)CommonUtils.cutStr(constsDesc, 100), rowIndex);
        model.setValue(settleParamField.constantsKey(), (Object)CommonUtils.cutStr(consts, 100), rowIndex);
        model.setValue(settleParamField.constantsTagKey(), (Object)consts, rowIndex);
    }

    @Override
    protected QFilter buildF7SelectFilter(String key, BeforeF7SelectEvent event) {
        switch (key) {
            case "demand": {
                DynamicObject supplier = (DynamicObject)this.getValue("supplier");
                return new QFilter("id", "!=", (Object)DynamicObjectUtil.getPkValue(supplier));
            }
        }
        return super.buildF7SelectFilter(key, event);
    }
}

