/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.ism.business.helper.filter.CommonF7SelectFilterHelper;
import kd.scmc.ism.common.model.mapper.OrgAndRepresentativeMapper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.formplugin.template.BaseMatchConditonEdit;
import kd.scmc.ism.lang.FormLang;

public class SettleRelationsEdit
extends BaseMatchConditonEdit
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, "owner", "supplier", "supplierwarehouseorg", "supplierwarehouse", "supplierlocation", "demand", "settleorg", "demandwarehouseorg", "demandwarehouse", "demandlocation", "saleorg", "purorg", "bulerelation", "prerelation");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String bizDirect = (String)this.getModel().getValue("bizdirect");
        this.setBuleDirectEnable(bizDirect);
        this.lockLocation();
        this.handleDynaPath((Boolean)this.getValue("isdynapath"));
        this.getView().setVisible(Boolean.valueOf(this.getModel().getValue("tooutgenerateplan") != null), new String[]{"gensequence"});
        this.getModel().setDataChanged(false);
    }

    private void setBuleDirectEnable(String bizDirect) {
        Boolean isBuleDirect = "R".equals(bizDirect);
        this.getView().setEnable(isBuleDirect, new String[]{"bulerelation"});
        this.getView().setVisible(isBuleDirect, new String[]{"bulerelation"});
    }

    private void lockLocation() {
        DynamicObjectCollection enties = this.getModel().getEntryEntity("settlerelationdetail");
        for (int i = 0; i < enties.size(); ++i) {
            DynamicObject entry = (DynamicObject)enties.get(i);
            DynamicObject demandWarehouse = entry.getDynamicObject("demandwarehouse");
            DynamicObject supplierWarehouse = entry.getDynamicObject("supplierwarehouse");
            if (supplierWarehouse == null || !supplierWarehouse.getBoolean("isopenlocation")) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"supplierlocation"});
            }
            if (demandWarehouse != null && demandWarehouse.getBoolean("isopenlocation")) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"demandlocation"});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IFormView view = this.getView();
        String entryName = e.getEntryProp().getName();
        if ("settlerelationdetail".equals(entryName)) {
            RowDataEntity[] rows = e.getRowDataEntities();
            DynamicObject info = this.getModel().getDataEntity();
            for (RowDataEntity row : rows) {
                int rowIndex = row.getRowIndex();
                DynamicObject tempOwner = null;
                if (rowIndex == 0) {
                    tempOwner = (DynamicObject)this.getModel().getValue("settleorg");
                    this.getModel().setValue("supplier", (Object)tempOwner, rowIndex);
                    view.updateView("supplier", rowIndex);
                } else if (row.getDataEntity().getDynamicObject("supplier") == null) {
                    tempOwner = ((DynamicObject)info.getDynamicObjectCollection("settlerelationdetail").get(rowIndex - 1)).getDynamicObject("demand");
                    this.getModel().setValue("supplier", (Object)tempOwner, rowIndex);
                    view.updateView("supplier", rowIndex);
                }
                view.setEnable(Boolean.FALSE, rowIndex, new String[]{"supplierlocation", "demandlocation"});
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        param.setMultiSelect(false);
        try {
            switch (key) {
                case "settleorg": {
                    this.beforeSelectSettleOrg(evt);
                    break;
                }
                case "owner": {
                    this.beforeSelectOnwer(evt);
                    break;
                }
                case "demand": {
                    this.beforeSelectDemand(evt);
                    break;
                }
                case "supplierwarehouse": {
                    this.beforeSelectCommonEntryWarehouse(evt, "supplierwarehouseorg");
                    break;
                }
                case "supplierlocation": {
                    this.beforeSelectCommonEntryLocation(evt, "supplierwarehouse");
                    break;
                }
                case "demandwarehouse": {
                    this.beforeSelectCommonEntryWarehouse(evt, "demandwarehouseorg");
                    break;
                }
                case "demandlocation": {
                    this.beforeSelectCommonEntryLocation(evt, "demandwarehouse");
                    break;
                }
                case "bulerelation": {
                    this.beforeSelectBuleRelation(evt);
                    break;
                }
            }
        }
        catch (KDBizException e) {
            if (e.getErrorCode().getCode().equals("ISMEC-BZ0001")) {
                evt.setCancel(true);
                if (!evt.getSourceMethod().equals("setItemByNumber")) {
                    this.getView().showErrorNotification(e.getMessage());
                }
            }
            throw e;
        }
    }

    private void beforeSelectBuleRelation(BeforeF7SelectEvent evt) {
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        long id = this.getModel().getDataEntity().getLong("id");
        QFilter filter = new QFilter("bizdirect", "=", (Object)"B").and("id", "!=", (Object)id);
        param.getListFilterParameter().setFilter(filter);
    }

    private void beforeSelectSettleOrg(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        String bizDirect = (String)model.getValue("bizdirect");
        if ("R".equals(bizDirect)) {
            DynamicObject buleRelation = (DynamicObject)model.getValue("bulerelation");
            if (buleRelation == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(FormLang.plsSelectPosSettleRelation());
                return;
            }
            long relationId = buleRelation.getLong("id");
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            QFilter filter = CommonF7SelectFilterHelper.getSettleRelationOrgFilter(relationId);
            param.getListFilterParameter().setFilter(filter);
        }
    }

    private void beforeSelectOnwer(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        DynamicObject obj = (DynamicObject)model.getValue("settleorg");
        if (obj == null) {
            evt.setCancel(true);
            this.getView().showTipNotification(FormLang.plsSelectHeadSupplier());
            return;
        }
        QFilter qFilter = new QFilter("id", "!=", obj.getPkValue());
        String bizDirect = (String)model.getValue("bizdirect");
        if ("R".equals(bizDirect)) {
            DynamicObject buleRelation = (DynamicObject)model.getValue("bulerelation");
            long relationId = buleRelation.getLong("id");
            QFilter filter = CommonF7SelectFilterHelper.getSettleRelationOrgFilter(relationId);
            qFilter.and(filter);
        }
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        param.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeSelectDemand(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        if (CommonUtils.objectIsNull(model.getValue("owner"))) {
            this.getView().showTipNotification(FormLang.plsSelectHeadDemand());
            evt.setCancel(true);
            return;
        }
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        param.getListFilterParameter().setFilter(this.getDemandFilter(evt.getRow()));
    }

    private QFilter getDemandFilter(int rowIndex) {
        Object[] selectedSupplierId = new Object[rowIndex + 1];
        for (int i = 0; i <= rowIndex; ++i) {
            DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier", i);
            if (supplier == null) continue;
            selectedSupplierId[i] = supplier.getPkValue();
        }
        return new QFilter("id", "not in", (Object)selectedSupplierId);
    }

    private void beforeSelectCommonEntryWarehouse(BeforeF7SelectEvent evt, String whsorgKey) {
        DynamicObject whsorg = (DynamicObject)this.getValue(whsorgKey, evt.getRow());
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        param.getListFilterParameter().setFilter(this.getWarehouseFilter(Long.valueOf(whsorg.getPkValue().toString())));
    }

    private QFilter getWarehouseFilter(Long whsorgId) {
        List allWhs = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"IWareHouseService", (String)"getAllSetupWarehouseIDs", (Object[])new Object[]{Collections.singletonList(whsorgId)});
        return new QFilter("id", "in", (Object)allWhs);
    }

    private void beforeSelectCommonEntryLocation(BeforeF7SelectEvent evt, String warehouseKey) {
        DynamicObject warehouse = (DynamicObject)this.getValue(warehouseKey, evt.getRow());
        DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
        List<Long> ids = this.getLoactionIds(locationCol);
        QFilter qFilter1 = new QFilter("id", "in", ids);
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        param.getListFilterParameter().setFilter(qFilter1);
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (CommonUtils.collectionIsEmpty(locationCol)) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "isdynapath": {
                this.changeDynaPath(e);
                break;
            }
            case "bizdirect": {
                this.changeBizDirect(e);
                break;
            }
            case "bulerelation": {
                this.changeBuleRelation(e);
                break;
            }
            case "settleorg": {
                this.changeSettleOrg(e);
                break;
            }
            case "owner": {
                this.changeOwner(e);
                break;
            }
            case "prerelation": {
                this.changePreSettleRelation(e);
                break;
            }
            case "supplierwarehouseorg": {
                this.changeSupplierWarehouseOrg(e);
                break;
            }
            case "demandwarehouseorg": {
                this.changeDemandWarehouseOrg(e);
                break;
            }
            case "supplierwarehouse": {
                this.changeSupplierWarehouse(e);
                break;
            }
            case "demandwarehouse": {
                this.changeDemandWarehouse(e);
                break;
            }
            case "demand": {
                this.changeDemand(e);
                break;
            }
            case "tooutgenerateplan": {
                this.changeToOutGeneratePlan(e);
                break;
            }
        }
    }

    private void changeToOutGeneratePlan(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        this.getView().setVisible(Boolean.valueOf(changeSet.getNewValue() != null), new String[]{"gensequence"});
    }

    private void changeDynaPath(PropertyChangedArgs e) {
        Boolean isDynaPath = (Boolean)e.getChangeSet()[0].getNewValue();
        this.getModel().beginInit();
        this.getModel().deleteEntryData("settlerelationdetail");
        if (isDynaPath.booleanValue()) {
            this.getModel().createNewEntryRow("settlerelationdetail");
            this.getModel().setValue("settleorg", null);
            this.getModel().setValue("owner", null);
        }
        this.getModel().endInit();
        this.getView().updateView();
        this.handleDynaPath(isDynaPath);
    }

    private void handleDynaPath(Boolean isDynaPath) {
        this.getView().setVisible(Boolean.valueOf(isDynaPath == false), new String[]{"settleorg", "owner", "supplier", "demand", "prerelation", "advcontoolbarap1"});
    }

    private void changeBuleRelation(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (newValue == null) {
                this.getModel().setValue("settleorg", null);
                continue;
            }
            this.getModel().setValue("settleorg", newValue.get("settleorg"));
            this.getModel().setValue("owner", newValue.get("owner"));
        }
    }

    private void changeBizDirect(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        IDataModel model = this.getModel();
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            String bizDirect = (String)changeData.getNewValue();
            this.setBuleDirectEnable(bizDirect);
        }
        model.setValue("bulerelation", null);
        model.setValue("settleorg", null);
    }

    private void changeSupplierWarehouseOrg(PropertyChangedArgs e) {
        int index = e.getChangeSet()[0].getRowIndex();
        this.getModel().setValue("supplierwarehouse", null, index);
    }

    private void changeDemandWarehouseOrg(PropertyChangedArgs e) {
        int index = e.getChangeSet()[0].getRowIndex();
        this.getModel().setValue("demandwarehouse", null, index);
    }

    private void changeSupplierWarehouse(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        DynamicObject warehouse = (DynamicObject)data.getNewValue();
        int rowindex = data.getRowIndex();
        this.getModel().setValue("supplierlocation", null, rowindex);
        if (!CommonUtils.objectIsNull(warehouse)) {
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isopenlocation), rowindex, new String[]{"supplierlocation"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"supplierlocation"});
        }
    }

    private void changeDemandWarehouse(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        DynamicObject warehouse = (DynamicObject)data.getNewValue();
        int rowindex = data.getRowIndex();
        this.getModel().setValue("demandlocation", null, rowindex);
        if (!CommonUtils.objectIsNull(warehouse)) {
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            this.getView().setEnable(Boolean.valueOf(isopenlocation), rowindex, new String[]{"demandlocation"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"demandlocation"});
        }
    }

    private void changeSettleOrg(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        model.setValue("owner", null);
        model.deleteEntryData("settlerelationdetail");
        DynamicObject newsettleorg = (DynamicObject)e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (!CommonUtils.objectIsNull(newsettleorg)) {
            this.createNewSettleRelationDetailEntry(rowIndex, null);
        }
    }

    private void changePreSettleRelation(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        DynamicObject preRelation = model.getDataEntity().getDynamicObject("prerelation");
        if (preRelation == null) {
            return;
        }
        DynamicObjectCollection entrys = (preRelation = BusinessDataServiceHelper.loadSingle((Object)preRelation.getPkValue(), (String)"ism_settlerelations")).getDynamicObjectCollection("settlerelationdetail");
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject newEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)entrys.get(i)), (boolean)true, (boolean)true);
            model.createNewEntryRow("settlerelationdetail", newEntry);
        }
    }

    private void changeOwner(PropertyChangedArgs e) {
        DynamicObject obj;
        IDataModel model = this.getModel();
        DynamicObject newOwner = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (newOwner == null) {
            return;
        }
        DynamicObjectCollection detail = model.getEntryEntity("settlerelationdetail");
        if (CommonUtils.collectionIsEmpty(detail)) {
            return;
        }
        Object newOwnerPkValue = newOwner.getPkValue();
        for (int i = 0; i < detail.size(); ++i) {
            Object pkValue;
            obj = ((DynamicObject)detail.get(i)).getDynamicObject("demand");
            if (obj == null || !newOwnerPkValue.equals(pkValue = obj.getPkValue())) continue;
            this.deleteDataEntryAfterIndex("settlerelationdetail", i);
            return;
        }
        int lastLineIndex = detail.size() - 1;
        obj = ((DynamicObject)detail.get(lastLineIndex)).getDynamicObject("demand");
        if (!CommonUtils.objectIsNull(obj)) {
            this.createNewSettleRelationDetailEntry(lastLineIndex, null);
        }
    }

    private void changeDemand(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData data = e.getChangeSet()[0];
        int curIndex = data.getRowIndex();
        DynamicObject demandNewValue = (DynamicObject)data.getNewValue();
        model.setValue("purorg", null, curIndex);
        model.setValue("demandwarehouseorg", null, curIndex);
        model.setValue("demandwarehouse", null, curIndex);
        model.setValue("demandlocation", null, curIndex);
        if (demandNewValue == null) {
            this.getView().setEnable(Boolean.FALSE, curIndex, new String[]{"demandwarehouseorg", "demandwarehouse"});
            return;
        }
        DynamicObject entryOwner = null;
        DynamicObjectCollection entrys = model.getEntryEntity("settlerelationdetail");
        if (curIndex < entrys.size() - 1) {
            entryOwner = (DynamicObject)model.getValue("supplier", curIndex + 1);
        }
        if (entryOwner != null && entryOwner.getPkValue().equals(demandNewValue.getPkValue())) {
            return;
        }
        this.getView().setEnable(Boolean.TRUE, curIndex, new String[]{"demandwarehouseorg", "demandwarehouse"});
        DynamicObject owner = (DynamicObject)model.getValue("owner");
        if (!owner.getPkValue().equals(demandNewValue.getPkValue())) {
            this.createNewSettleRelationDetailEntry(curIndex, demandNewValue);
        }
        this.setIsSamecorporate(curIndex);
    }

    private void setIsSamecorporate(int index) {
        IDataModel model = this.getModel();
        DynamicObject demand = (DynamicObject)model.getValue("demand", index);
        DynamicObject supplier = (DynamicObject)model.getValue("supplier", index);
        if (demand == null || supplier == null) {
            model.setValue("issamecorporate", (Object)Boolean.FALSE, index);
            return;
        }
        OrgAndRepresentativeMapper mapper = new OrgAndRepresentativeMapper();
        mapper.load(demand.getPkValue(), supplier.getPkValue());
        Boolean isSame = mapper.isSameRepresentative(supplier.getPkValue(), demand.getPkValue());
        model.setValue("issamecorporate", (Object)isSame, index);
    }

    private void deleteDataEntryAfterIndex(String entryentityKey, int index) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(entryentityKey);
        int leftCount = count - (index + 1);
        if (leftCount > 0) {
            int[] needDeleteRows = new int[leftCount];
            for (int i = 0; i < leftCount; ++i) {
                needDeleteRows[i] = --count;
            }
            model.deleteEntryRows(entryentityKey, needDeleteRows);
        }
    }

    private int createNewSettleRelationDetailEntry(int rowIndex, DynamicObject demandNewValue) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("settlerelationdetail");
        DynamicObject supplier = null;
        if (count == 0) {
            supplier = (DynamicObject)model.getValue("settleorg");
        }
        if (supplier == null) {
            supplier = demandNewValue;
        }
        int currentIndex = model.createNewEntryRow("settlerelationdetail");
        this.getModel().setValue("supplier", (Object)supplier, currentIndex);
        this.getView().updateView("supplier", currentIndex);
        return count;
    }
}

