/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.dynpage;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.MulComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.helper.BizConfigHelper;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.business.helper.filter.CommonFilterHelper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.control.DataRangeUtils;
import kd.scmc.ism.common.utils.control.EntryGridUtils;
import kd.scmc.ism.common.utils.control.MulComboUtils;
import kd.scmc.ism.formplugin.template.AbstractISMDynBillFormPlugin;
import kd.scmc.ism.model.log.SettleLogBatchChecker;
import kd.scmc.ism.model.log.SettleLogBatchFixer;

public class ExceptionBillFormPlugin
extends AbstractISMDynBillFormPlugin {
    private static final String BUTTON_LOG_UPDATE = "logupdate";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        MulComboEdit billType = (MulComboEdit)this.getView().getControl("billtypebiz");
        MulComboUtils.fillsWithBill(BizConfigHelper.getEnableBFMBillObjs(), billType);
        DataRangeUtils.setOneMonth(this.getModel(), "daterange_startdate", "daterange_enddate");
    }

    private QFilter[] buildLogFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("createstatus", "in", (Object)new String[]{"A", "E"}));
        String billTypeStr = (String)this.getModel().getValue("billtypebiz");
        List<String> billTypes = MulComboUtils.getMultiCombValue(billTypeStr, new String[0]);
        if (!billTypes.isEmpty()) {
            filters.add(new QFilter("sourcetype", "in", billTypes));
        }
        filters.add(new QFilter("createdate", ">=", this.getModel().getValue("daterange_startdate")));
        filters.add(new QFilter("createdate", "<=", this.getModel().getValue("daterange_enddate")));
        QFilter fromToFilter = CommonFilterHelper.getFromToFilter("sourcenum", (String)this.getModel().getValue("billnofrom"), (String)this.getModel().getValue("billnoto"));
        if (fromToFilter != null) {
            filters.add(fromToFilter);
        }
        return filters.toArray(new QFilter[filters.size()]);
    }

    @Override
    protected void doQuery(AfterDoOperationEventArgs event) {
        DynamicObjectCollection logInfos = this.querySettleLog(this.buildLogFilter());
        Map<Long, String> doChecks = this.doCheck(logInfos);
        this.getModel().deleteEntryData("entryentity");
        if (CommonUtils.mapIsEmpty(doChecks)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", doChecks.size());
        int i = 0;
        this.getModel().beginInit();
        for (Map.Entry<Long, String> check : doChecks.entrySet()) {
            Long logId = check.getKey();
            String failReason = check.getValue();
            this.getModel().setValue("logid", (Object)logId, i);
            this.getModel().setValue("settlelogid", (Object)logId, i);
            this.getModel().setValue("excptype", (Object)failReason, i);
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private Map<Long, String> doCheck(DynamicObjectCollection logInfos) {
        SettleLogBatchChecker checker = new SettleLogBatchChecker();
        for (DynamicObject logInfo : logInfos) {
            long logid = logInfo.getLong("id");
            checker.addLogSrcInfo(logid, logInfo.getLong("sourceid"), logInfo.getString("sourcetype"));
            checker.addLogSettleInfo(logid, logInfo.getLong("settlebillid"), logInfo.getString("settlebilltype"));
        }
        return checker.doCheck();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "billnofrom": {
                this.changeBillNoFrom(e, "billnoto");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "logupdate": {
                this.logFixUpdate();
                break;
            }
        }
    }

    private void logFixUpdate() {
        List<DynamicObject> entryList = EntryGridUtils.getSelectEntries(this.getView(), "entryentity");
        SettleLogBatchFixer fixer = new SettleLogBatchFixer();
        for (DynamicObject entry : entryList) {
            DynamicObject settleLog = entry.getDynamicObject("settlelogid");
            Long logid = DynamicObjectUtil.getPkValue(settleLog);
            fixer.addErroLogInfo(logid, entry.getString("excptype"));
        }
        Map<Long, String> resultInfo = fixer.doFix();
        if (CommonUtils.mapIsNotEmpty(resultInfo)) {
            HashMap<String, Object> billFailInfo = new HashMap<String, Object>(resultInfo.size());
            for (Map.Entry<Long, String> failInfo : resultInfo.entrySet()) {
                billFailInfo.put(failInfo.getKey().toString(), failInfo.getValue());
            }
            PageShowHelper.showOperResult(this.getView(), billFailInfo);
        }
        this.getView().invokeOperation("queryap");
    }

    public void hyperLinkClick(HyperLinkClickEvent paramEvent) {
        String fieldName = paramEvent.getFieldName();
        int row = paramEvent.getRowIndex();
        switch (fieldName) {
            case "excptype": {
                this.showCheckInfo(row);
                break;
            }
            case "scrnum": {
                this.showBillInfo(row);
            }
        }
    }

    private void showBillInfo(int row) {
        DynamicObject logInfo = (DynamicObject)this.getModel().getValue("settlelogid", row);
        logInfo.getLong("sourceid");
        logInfo.getString("sourcetype");
    }

    private void showCheckInfo(int ... rows) {
        ArrayList<Long> logIds = new ArrayList<Long>(128);
        for (int i : rows) {
            DynamicObject logInfo = (DynamicObject)this.getModel().getValue("settlelogid", i);
            logIds.add(DynamicObjectUtil.getPkValue(logInfo));
        }
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("isviewmode", Boolean.TRUE.toString());
        DynamicObjectCollection settleLogs = this.querySettleLog(new QFilter("id", "in", logIds).toArray());
        ArrayList<Map<String, Object>> vbillInfos = new ArrayList<Map<String, Object>>(128);
        for (DynamicObject slog : settleLogs) {
            HashMap<String, Object> vbillInfo = new HashMap<String, Object>(16);
            vbillInfo.put("srcbillid", slog.getLong("sourceid"));
            vbillInfo.put("srcbilltype", slog.getString("sourcetype"));
            vbillInfo.put("srcbillno", slog.getString("sourcenum"));
            vbillInfo.put("vbillid", slog.getLong("settlebillid"));
            vbillInfo.put("vbilltype", slog.getString("settlebilltype"));
            vbillInfo.put("vbillno", slog.getString("settlebillno"));
            vbillInfos.add(vbillInfo);
        }
        PageShowHelper.showVBillInfo(this.getView(), vbillInfos, param);
    }

    private DynamicObjectCollection querySettleLog(QFilter[] filters) {
        return QueryServiceHelper.query((String)"ism_settlelog", (String)"id, sourceid, sourcenum, sourcetype, createdate,entryentity.settlebillid as settlebillid, entryentity.settlebilltype as settlebilltype,entryentity.settlebillno as settlebillno", (QFilter[])filters);
    }
}

