/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.dynpage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.util.StringUtils;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.business.action.SettleActionFactory;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.common.errocode.ISMErrorCode;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.formplugin.dynpage.validate.AbstractIsmFuncValidateFormPlugin;
import kd.scmc.ism.lang.FormLang;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.unit.AbstractMatchUnit;
import kd.scmc.ism.model.match.unit.impl.BizDirectMatchUnit;
import kd.scmc.ism.model.match.unit.impl.SettleJudgeMatchUnit;
import kd.scmc.ism.model.match.unit.impl.SettleParamMatchUnit;
import kd.scmc.ism.model.match.unit.impl.SettleRelationMatchUnit;
import kd.scmc.ism.model.relation.AbstractRelationModel;
import kd.scmc.ism.model.relation.RelationEntryModel;

public class IsmFuncValidateFromPlugin
extends AbstractIsmFuncValidateFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"generatebill"});
        this.addClickListeners(new String[]{"generatebill", "btnsource"});
        this.addItemClickListeners(new String[]{"bizdirectbar", "settlejudgebar", "relationmatchbar", "batchexecutebar", "parammatchbar"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabap", "tabpageap", "pricefunction"});
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        switch (key = FormUtils.getControlEventKey(e)) {
            case "generatebill": {
                this.clickGenerateBill(this.getBillType());
                break;
            }
            case "btnsource": {
                this.clickSrcMatch();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bizjudge": 
            case "judgesettle": 
            case "relationmatch": 
            case "parammatch": {
                this.clickSrcMatch();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "generaterelation": {
                this.changeGenerateRelation(e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clickSrcMatch() {
        this.getModel().getDataEntity(true);
        IDataModel model = this.getModel();
        model.deleteEntryData("judgesettleentry");
        model.deleteEntryData("bizdirectjudgelist");
        model.deleteEntryData("matchrelations");
        model.deleteEntryData("spentryentity");
        model.deleteEntryData("stpentry");
        try {
            String billtype = this.getBillType();
            List<DynamicObject> bills = this.getSelectedBill(billtype);
            if (CommonUtils.collectionIsEmpty(bills)) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billlist");
                int[] selectRowIndex = entryGrid.getSelectRows();
                PageShowHelper.showOperResult(this.getView(), this.getErrorInfoWithNo(selectRowIndex));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabap", "tabpageap"});
                return;
            }
            Set<Long> billIds = DynamicObjectUtil.getDynamicObjectIds(bills);
            ISMRequestContext requestContext = ISMRequestContext.create(billtype, billIds);
            ISMServiceContext sbizContext = ISMServiceContext.build();
            List<AbstractSettleAction> settleActions = SettleActionFactory.buildPreMatchActions();
            for (AbstractSettleAction action : settleActions) {
                action.setReqContext(requestContext);
                action.setServiceContext(sbizContext);
                action.action();
            }
            model.beginInit();
            this.showSettleJudge(bills, requestContext);
            this.showBizDirectInfo(bills, requestContext);
            this.showRelationMatch(bills, requestContext);
            this.showSettleParam(bills, requestContext);
            model.endInit();
            Map<Long, String> selectedBillIdAndNo = this.getBillIdAndNo(bills);
            Map<Long, String> billNotExist = this.getSelectedBillNotExist(selectedBillIdAndNo);
            this.addErrorInfo(requestContext.getOperResult(), billNotExist);
            this.showSettleOperateResult(requestContext.getOperResult(), billNotExist);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabap", "tabpageap"});
        }
        catch (KDException e) {
            this.getView().showTipNotification(e.getMessage());
        }
        finally {
            this.getView().updateView("judgesettleentry");
            this.getView().updateView("bizdirectjudgelist");
            this.getView().updateView("matchrelations");
            this.getView().updateView("spentryentity");
            this.getView().updateView("spsubentryentity");
            this.getView().updateView("stpentry");
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("tabpageap");
        }
    }

    private void showSettleJudge(List<DynamicObject> bills, ISMRequestContext requestContext) {
        IDataModel model = this.getModel();
        Map<Long, MatchResult<?>> matchUnits = requestContext.getMatchUnits(SettleJudgeMatchUnit.class);
        int[] indexs = model.batchCreateNewEntryRow("judgesettleentry", bills.size());
        int i = 0;
        for (DynamicObject bill : bills) {
            MatchResult<?> result;
            long billId = bill.getLong("id");
            int index = indexs[i];
            model.setValue("judgebillno", (Object)bill.getString("billno"), index);
            if (CommonUtils.mapIsNotEmpty(matchUnits) && (result = matchUnits.get(billId)) != null) {
                model.setValue("interorgsettleconfig", (Object)((AbstractMatchUnit)result.getMatchedUnit()).getResultObject(), index);
            }
            ++i;
        }
    }

    private void showBizDirectInfo(List<DynamicObject> bills, ISMRequestContext requestContext) {
        IDataModel model = this.getModel();
        Map<Long, MatchResult<?>> matchUnits = requestContext.getMatchUnits(BizDirectMatchUnit.class);
        int[] indexs = model.batchCreateNewEntryRow("bizdirectjudgelist", bills.size());
        int i = 0;
        for (DynamicObject bill : bills) {
            long billId;
            MatchResult<?> result;
            int index = indexs[i];
            model.setValue("bizdirectbillno", (Object)bill.getString("billno"), index);
            if (matchUnits != null && (result = matchUnits.get(billId = bill.getLong("id"))) != null) {
                model.setValue("bizdirect", (Object)((AbstractMatchUnit)result.getMatchedUnit()).getResultObject(), index);
            }
            ++i;
        }
    }

    private void showRelationMatch(List<DynamicObject> bills, ISMRequestContext requestContext) {
        SettleBillMapCfg mapCfg = SettleBillMapCfg.buildAll();
        Map<Long, MatchResult<?>> matchUnits = requestContext.getMatchUnits(SettleRelationMatchUnit.class);
        IDataModel model = this.getModel();
        if (matchUnits == null || matchUnits.size() == 0) {
            return;
        }
        String materialKey = mapCfg.getFieldKey(this.getBillType(), "material");
        int[] rowIndexs = model.batchCreateNewEntryRow("matchrelations", matchUnits.size());
        int i = 0;
        HashMap<Long, DynamicObject> billInfos = new HashMap<Long, DynamicObject>(bills.size());
        HashMap<Long, DynamicObject> entryInfos = new HashMap<Long, DynamicObject>(bills.size());
        for (DynamicObject bill : bills) {
            billInfos.put(DynamicObjectUtil.getPkValue(bill), bill);
            String entryKey = mapCfg.getFieldKey(bill.getDataEntityType().getName(), "billentry");
            String billno = bill.getString("billno");
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : entries) {
                long entryid = entry.getLong("id");
                entryInfos.put(entryid, entry);
                MatchResult<?> result = matchUnits.get(entryid);
                if (result == null) continue;
                int rowIndex = rowIndexs[i];
                model.setValue("matchrelationbillno", (Object)billno, rowIndex);
                model.setValue("matchrelationentryid", (Object)entry.getLong("id"), rowIndex);
                if (StringUtils.isNotEmpty((String)materialKey)) {
                    DynamicObject material = entry.getDynamicObject(materialKey);
                    if (material != null && !"bd_material".equals(material.getDataEntityType().getName())) {
                        material = material.getDynamicObject("masterid");
                    }
                    model.setValue("matchrelationmaterial", (Object)material, rowIndex);
                }
                model.setValue("matchedrelation", (Object)((AbstractMatchUnit)result.getMatchedUnit()).getResultObject(), rowIndex);
                model.setValue("matchrelationseq", entry.get("seq"), rowIndex);
                ++i;
            }
        }
        Map<Long, List<AbstractRelationModel>> relations = requestContext.getRelations();
        int totalSize = 0;
        for (List<AbstractRelationModel> relModels : relations.values()) {
            totalSize += relModels.size();
        }
        if (totalSize == 0) {
            return;
        }
        model.batchCreateNewEntryRow("spentryentity", totalSize);
        int j = 0;
        for (Map.Entry<Long, List<AbstractRelationModel>> relationEntry : relations.entrySet()) {
            Long billId = relationEntry.getKey();
            DynamicObject bill = (DynamicObject)billInfos.get(billId);
            List<AbstractRelationModel> value = relationEntry.getValue();
            for (AbstractRelationModel relationModel : value) {
                model.setValue("spbillno", (Object)bill.getString("billno"), j);
                model.setValue("sprelation", (Object)relationModel.getRelationObj(), j);
                model.setValue("spentrysize", (Object)relationModel.getRows().size(), j);
                model.setValue("spsuporg", (Object)relationModel.getSupplierId(), j);
                model.setValue("spdemandorg", (Object)relationModel.getDemandId(), j);
                DynamicObjectCollection subEntries = (DynamicObjectCollection)this.getModel().getValue("spsubentryentity", j);
                subEntries.clear();
                Collection<ListSelectedRow> values = relationModel.getRows().values();
                for (ListSelectedRow row : values) {
                    DynamicObject rowEntry = subEntries.addNew();
                    Long entryId = (Long)row.getEntryPrimaryKeyValue();
                    rowEntry.set("spentryid", (Object)entryId);
                    DynamicObject entry = (DynamicObject)entryInfos.get(entryId);
                    rowEntry.set("spentryseq", entry.get("seq"));
                    if (!StringUtils.isNotEmpty((String)materialKey)) continue;
                    DynamicObject material = entry.getDynamicObject(materialKey);
                    if (material != null && !"bd_material".equals(material.getDataEntityType().getName())) {
                        material = material.getDynamicObject("masterid");
                    }
                    rowEntry.set("spentrymaterial", (Object)material);
                }
                ++j;
            }
        }
    }

    private void showSettleParam(List<DynamicObject> bills, ISMRequestContext requestContext) {
        IDataModel model = this.getModel();
        Map<Long, List<AbstractRelationModel>> relations = requestContext.getRelations();
        for (DynamicObject bill : bills) {
            Long billId = DynamicObjectUtil.getPkValue(bill);
            String billNo = bill.getString("billno");
            List<AbstractRelationModel> relationModels = relations.get(billId);
            if (relationModels == null) continue;
            for (AbstractRelationModel relModel : relationModels) {
                DynamicObject relationObj = relModel.getRelationObj();
                Long headSupplierId = relModel.getSupplierId();
                Long headDemandId = relModel.getDemandId();
                for (RelationEntryModel relEntryModel : relModel.getRelationEntries()) {
                    Long entrySupplierId = relEntryModel.getSupplierId();
                    Long entryDemandId = relEntryModel.getDemandId();
                    int entrySeq = relEntryModel.getObj().getInt("seq");
                    MatchResult<SettleParamMatchUnit> settleParamMU = relEntryModel.getSettleParamMU();
                    if (settleParamMU == null || !settleParamMU.isMatch()) continue;
                    int row = model.createNewEntryRow("stpentry");
                    model.setValue("stpbillno", (Object)billNo, row);
                    model.setValue("stprelation", (Object)relationObj, row);
                    model.setValue("stpsupplier", (Object)headSupplierId, row);
                    model.setValue("stpdemand", (Object)headDemandId, row);
                    model.setValue("stprelationseq", (Object)entrySeq, row);
                    model.setValue("stpesupplier", (Object)entrySupplierId, row);
                    model.setValue("sptedemand", (Object)entryDemandId, row);
                    model.setValue("settleparam", (Object)settleParamMU.getMatchedUnit().getResultObject(), row);
                }
            }
        }
    }

    private void changeGenerateRelation(PropertyChangedArgs e) {
        ChangeData[] changeDatas = e.getChangeSet();
        HashMap<Integer, String> pathKeys = new HashMap<Integer, String>();
        this.getModel().setValue("generatepath", null);
        for (ChangeData changeData : changeDatas) {
            DynamicObject settleRelation = (DynamicObject)changeData.getNewValue();
            pathKeys.clear();
            if (settleRelation == null) continue;
            DynamicObjectCollection paths = settleRelation.getDynamicObjectCollection("settlerelationdetail");
            for (int i = 0; i < paths.size(); ++i) {
                DynamicObject path = (DynamicObject)paths.get(i);
                DynamicObject supplier = path.getDynamicObject("supplier");
                DynamicObject demand = path.getDynamicObject("demand");
                String pathStr = supplier.getString("name") + '-' + demand.getString("name");
                pathKeys.put(i, pathStr);
            }
        }
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(pathKeys.size());
        for (Map.Entry keys : pathKeys.entrySet()) {
            Integer index = (Integer)keys.getKey();
            String value = (String)keys.getValue();
            LocaleString caption1 = new LocaleString(value);
            ComboItem item = new ComboItem();
            item.setCaption(caption1);
            item.setId("" + index);
            item.setValue("" + index);
            itemList.add(item);
        }
        ComboEdit generatePathComb = (ComboEdit)this.getView().getControl("generatepath");
        generatePathComb.setComboItems(itemList);
        this.getView().updateView("generatepath");
    }

    private void clickGenerateBill(String billtype) {
    }

    private void addErrorInfo(SettleOperResult operateResult, Map<Long, String> billMap) {
        for (long billId : billMap.keySet()) {
            operateResult.addFailInfo((Long)billId, ISMErrorCode.queryNoData(FormLang.curBillNotExist()));
        }
    }

    private Map<String, Object> getErrorInfoWithNo(int ... index) {
        IDataModel model = this.getModel();
        HashMap<String, Object> errorInfo = new HashMap<String, Object>(index.length);
        for (int i : index) {
            String billNo = (String)model.getValue("billno", i);
            errorInfo.put(billNo, FormLang.curBillNotExist());
        }
        return errorInfo;
    }
}

