/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.dynpage.popup;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.GetValByConditionEdit;
import kd.bos.entity.botp.CRFormula;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.lang.FormLang;

public class ISMGetValByConditionEdit
extends GetValByConditionEdit {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"selecttype", "formuladesc"});
    }

    public void click(EventObject e) {
        String srcCtrlKey = ((Control)e.getSource()).getKey();
        if (srcCtrlKey.equalsIgnoreCase("conditiondesc")) {
            this.showConditionForm();
        } else if (srcCtrlKey.equalsIgnoreCase("constantdesc")) {
            Object prop = this.getView().getFormShowParameter().getCustomParams().get("comboProp");
            if (prop != null) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("ide_comboitemsselect");
                showParameter.getCustomParams().put("comboProp", prop);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "comboConstantdesc"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            } else {
                super.click(e);
            }
        } else if (srcCtrlKey.equalsIgnoreCase("btnok")) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> eptEntrySeq = new ArrayList<String>(16);
            for (DynamicObject entry : entries) {
                String cdt = entry.getString("condition");
                String fml = entry.getString("constantdesc");
                if (!StringUtils.isEmpty((CharSequence)cdt) && !StringUtils.isEmpty((CharSequence)fml)) continue;
                eptEntrySeq.add(entry.getString("seq"));
            }
            if (eptEntrySeq.isEmpty()) {
                super.click(e);
            } else {
                this.getView().showTipNotification(FormLang.plsInsetConditionOrFormula(eptEntrySeq));
            }
        } else {
            super.click(e);
        }
    }

    private void showConditionForm() {
        FormShowParameter showParameter = PageShowHelper.getConditionParam(new CloseCallBack((IFormPlugin)this, "conditiondesc"));
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        String conditionJson = (String)this.getModel().getValue("condition", rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        String fieldNodes = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
        if (StringUtils.isNotBlank((CharSequence)funcsXML)) {
            showParameter.getCustomParams().put("functiontypes", funcsXML);
        }
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getActionId().equals("comboConstantdesc")) {
            this.receiveComboConstant(e.getReturnData());
        } else {
            super.closedCallBack(e);
        }
    }

    private void receiveComboConstant(Object returnData) {
        String json = (String)returnData;
        if (json == null) {
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)json, CRFormula.class);
        this.getModel().setValue("constant", (Object)json, row);
        this.getModel().setValue("constantdesc", (Object)formula.getExprTran(), row);
        this.getModel().setValue("ifconstant", (Object)1, row);
        this.getModel().setValue("formula", (Object)"", row);
        this.getModel().setValue("formuladesc", (Object)"", row);
    }
}

