/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.dynpage.popup;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.helper.BillBusinessHelper;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.common.result.BatchBillOpResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.CommonLang;
import kd.scmc.ism.lang.FormLang;
import kd.scmc.ism.lang.ReportLang;
import kd.scmc.ism.model.flow.BillBatchFlowExecutor;

public class VBillInfoEdit
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String vBillInfo = (String)this.getView().getFormShowParameter().getCustomParams().get("vbillinfo");
        if (StringUtils.isNotEmpty((CharSequence)vBillInfo)) {
            List infos = (List)SerializationUtils.fromJsonString((String)vBillInfo, List.class);
            if (CommonUtils.collectionIsEmpty(infos)) {
                return;
            }
            this.getModel().deleteEntryData("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", infos.size());
            int i = 0;
            for (Map map : infos) {
                this.getModel().setValue("srcbillid", map.get("srcbillid"), i);
                this.getModel().setValue("srcbillno", map.get("srcbillno"), i);
                this.getModel().setValue("srcbillobj", map.get("srcbilltype"), i);
                this.getModel().setValue("vbillid", map.get("vbillid"), i);
                this.getModel().setValue("vbillno", map.get("vbillno"), i);
                this.getModel().setValue("vbillobj", map.get("vbilltype"), i);
                ++i;
            }
            this.refreshBillStatus();
            this.checkIsOnSettleLog();
            this.onlyCheckMode();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "refresh": {
                this.refreshBillStatus();
                break;
            }
            case "vbilldelete": {
                this.doVBillDelete();
                break;
            }
        }
    }

    private void doVBillDelete() {
        Map<String, Set<Long>> entityToIds = this.getSelectedVBillInfo();
        if (CommonUtils.mapIsEmpty(entityToIds)) {
            this.getView().showTipNotification(FormLang.plsSelectOneNoDeleteAndRecordBill());
            return;
        }
        this.getView().showConfirm(ReportLang.vbillDeleteCheck(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("vbilldelete", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("vbilldelete".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            Map<String, Set<Long>> entityToIds = this.getSelectedVBillInfo();
            HashMap<Long, String> billInfosMap = new HashMap<Long, String>(16);
            BillBatchFlowExecutor executor = new BillBatchFlowExecutor();
            for (Map.Entry<String, Set<Long>> billIds : entityToIds.entrySet()) {
                DynamicObject[] simpleBillInfo;
                for (DynamicObject billObj : simpleBillInfo = BillBusinessHelper.getSimpleBillInfo(billIds.getKey(), new QFilter("id", "in", billIds.getValue()))) {
                    billInfosMap.put(billObj.getLong("id"), billObj.getString("billno"));
                    executor.addBill(billObj);
                }
            }
            BatchBillOpResult positiveExecute = executor.negativeExecute();
            this.refreshBillStatus();
            if (positiveExecute.isSuccess()) {
                this.getView().showSuccessNotification(CommonLang.executeSuccess());
            } else {
                Map<String, Object> failReasonInfo = positiveExecute.getFailReasonInfoWithNo(billInfosMap);
                if (CommonUtils.mapIsNotEmpty(failReasonInfo)) {
                    PageShowHelper.showOperResult(this.getView(), failReasonInfo);
                }
            }
        }
    }

    private Map<String, Set<Long>> getSelectedVBillInfo() {
        int[] selectRowIdex;
        HashMap<String, Set<Long>> entityToIds = new HashMap<String, Set<Long>>(16);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        for (int i : selectRowIdex = entryGrid.getSelectRows()) {
            String isRecord = (String)this.getModel().getValue("record", i);
            long vBillId = (Long)this.getModel().getValue("vbillid", i);
            DynamicObject vBillEntity = (DynamicObject)this.getModel().getValue("vbillobj", i);
            String vBillStatus = (String)this.getModel().getValue("vbillstatus", i);
            if (vBillEntity == null || "1".equals(isRecord) || "DELETE".equals(vBillStatus)) continue;
            String vBillEntityType = vBillEntity.getString("number");
            CommonUtils.mapGetSetValue(entityToIds, vBillEntityType).add(vBillId);
        }
        return entityToIds;
    }

    public void hyperLinkClick(HyperLinkClickEvent paramEvent) {
        String fieldName = paramEvent.getFieldName();
        int row = paramEvent.getRowIndex();
        switch (fieldName) {
            case "srcbillno": {
                this.showBillInfo("srcbillid", "srcbillobj", row);
                break;
            }
            case "vbillno": {
                this.showBillInfo("vbillid", "vbillobj", row);
            }
        }
    }

    private void showBillInfo(String billIdKey, String billObjKey, int row) {
        String entity = ((DynamicObject)this.getModel().getValue(billObjKey, row)).getString("number");
        PageShowHelper.showBillEdit(this.getView(), entity, this.getModel().getValue(billIdKey, row));
    }

    private void refreshBillStatus() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashMap<String, Set<Long>> billIds = new HashMap<String, Set<Long>>(16);
        for (DynamicObject entry : entryEntity) {
            Long vbillId;
            Long srcbillId = entry.getLong("srcbillid");
            if (CommonUtils.idIsNotNull(srcbillId)) {
                String srcbillType = entry.getDynamicObject("srcbillobj").getString("number");
                CommonUtils.mapGetSetValue(billIds, srcbillType).add(srcbillId);
            }
            if (!CommonUtils.idIsNotNull(vbillId = Long.valueOf(entry.getLong("vbillid")))) continue;
            String vbillType = entry.getDynamicObject("vbillobj").getString("number");
            CommonUtils.mapGetSetValue(billIds, vbillType).add(vbillId);
        }
        Map<Long, String> billStatusInfo = BillBusinessHelper.getBillStatusInfo(billIds);
        int i = 0;
        for (DynamicObject entry : entryEntity) {
            Long srcbillId = entry.getLong("srcbillid");
            String srcBillStatus = billStatusInfo.get(srcbillId);
            if (StringUtils.isEmpty((CharSequence)srcBillStatus)) {
                srcBillStatus = "DELETE";
            }
            this.getModel().setValue("srcbillstatus", (Object)srcBillStatus, i);
            Long vbillId = entry.getLong("vbillid");
            String vbillstatus = billStatusInfo.get(vbillId);
            if (StringUtils.isEmpty((CharSequence)vbillstatus)) {
                vbillstatus = "DELETE";
            }
            this.getModel().setValue("vbillstatus", (Object)vbillstatus, i);
            ++i;
        }
    }

    private void checkIsOnSettleLog() {
        boolean isCheckLog = String.valueOf(true).equals(this.getView().getFormShowParameter().getCustomParam("ischecklog"));
        this.getView().setVisible(Boolean.valueOf(isCheckLog), new String[]{"record"});
        if (isCheckLog) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            HashMap<Long, Integer> vbillIdToIndex = new HashMap<Long, Integer>(entryEntity.size());
            int i = 0;
            for (DynamicObject entry : entryEntity) {
                Long vbillId = entry.getLong("vbillid");
                vbillIdToIndex.put(vbillId, i);
                ++i;
            }
            DynamicObjectCollection recordIds = QueryServiceHelper.query((String)"ism_settlelog", (String)"entryentity.settlebillid as settlebillid", (QFilter[])new QFilter("entryentity.settlebillid", "in", vbillIdToIndex.keySet()).toArray());
            for (DynamicObject recordId : recordIds) {
                long settleBillId = recordId.getLong("settlebillid");
                Integer index = (Integer)vbillIdToIndex.get(settleBillId);
                this.getModel().setValue("record", (Object)"1", index.intValue());
            }
        }
    }

    private void onlyCheckMode() {
        boolean isOnlyCheck = String.valueOf(true).equals(this.getView().getFormShowParameter().getCustomParam("isviewmode"));
        this.getView().setVisible(Boolean.valueOf(!isOnlyCheck), new String[]{"vbilldelete"});
    }
}

