/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.dynpage.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.business.action.SettleActionProcessor;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.common.errocode.ISMErrorCode;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.formplugin.template.AbstractISMFormPlugin;
import kd.scmc.ism.lang.FormLang;
import kd.scmc.ism.lang.ModelLang;

public abstract class AbstractIsmFuncValidateFormPlugin
extends AbstractISMFormPlugin {
    private ISMServiceContext serviceContext = null;

    protected final String getBillType() {
        DynamicObject billType = (DynamicObject)this.getValue("billtype");
        return billType.getString("number");
    }

    protected final DynamicObject getCurrentSelectBill(String bill) {
        int index = this.getModel().getEntryCurrentRowIndex("billlist");
        List<DynamicObject> selectedBill = this.getBill(bill, index);
        if (selectedBill.isEmpty()) {
            throw new KDBizException(ISMErrorCode.queryNoData(FormLang.curBillNotExist()), new Object[0]);
        }
        return selectedBill.get(0);
    }

    protected final List<DynamicObject> getSelectedBill(String billtype) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billlist");
        int[] selectRowIdex = entryGrid.getSelectRows();
        if (selectRowIdex.length == 0) {
            throw new KDBizException(FormLang.plsSelectExecuteData());
        }
        return this.getBill(billtype, selectRowIdex);
    }

    protected final Map<Long, String> getBillIdAndNo(List<DynamicObject> billList) {
        HashMap<Long, String> billMap = new HashMap<Long, String>(16);
        for (DynamicObject bill : billList) {
            billMap.put((Long)bill.getPkValue(), bill.getString("billno"));
        }
        return billMap;
    }

    protected final Map<Long, String> getSelectedBillNotExist(Map<Long, String> selectedBill) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billlist");
        int[] selectRowIdex = entryGrid.getSelectRows();
        HashMap<Long, String> notExistBill = new HashMap<Long, String>(16);
        IDataModel model = this.getModel();
        for (int i : selectRowIdex) {
            String billNo = (String)model.getValue("billno", i);
            if (!StringUtils.isNotEmpty((CharSequence)billNo) || selectedBill.containsValue(billNo)) continue;
            notExistBill.put(Long.valueOf(i), billNo);
        }
        return notExistBill;
    }

    protected final List<Integer> getBillIndex(List<String> billNos) {
        ArrayList<Integer> billIndex = new ArrayList<Integer>(billNos.size());
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billlist");
        int[] selectRowIdex = entryGrid.getSelectRows();
        IDataModel model = this.getModel();
        for (int rowIndex : selectRowIdex) {
            String billNo = (String)model.getValue("billno", rowIndex);
            if (!StringUtils.isNotEmpty((CharSequence)billNo) || !billNos.contains(billNo)) continue;
            billIndex.add(rowIndex);
        }
        return billIndex;
    }

    protected final List<DynamicObject> getBill(String billtype, int ... indexs) {
        IDataModel model = this.getModel();
        ArrayList<String> billNos = new ArrayList<String>(indexs.length);
        ArrayList<String> eptEntrySeqs = new ArrayList<String>(indexs.length);
        for (int i : indexs) {
            String billNo = (String)model.getValue("billno", i);
            if (StringUtils.isNotEmpty((CharSequence)billNo)) {
                billNos.add((String)model.getValue("billno", i));
                continue;
            }
            eptEntrySeqs.add(String.valueOf(i + 1));
        }
        if (!eptEntrySeqs.isEmpty()) {
            throw new KDBizException(FormLang.plsInputBillNo(CommonUtils.transToStr(eptEntrySeqs)));
        }
        QFilter filter = new QFilter("billno", "in", billNos);
        Map querybills = BusinessDataServiceHelper.loadFromCache((String)billtype, (QFilter[])filter.toArray());
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(querybills.size());
        for (DynamicObject bill : querybills.values()) {
            bills.add(bill);
        }
        return bills;
    }

    public ISMServiceContext getServiceContext() {
        if (this.serviceContext == null) {
            this.serviceContext = ISMServiceContext.build();
        }
        return this.serviceContext;
    }

    public void showSettleOperResult(SettleOperResult operResult) {
        if (operResult == null) {
            return;
        }
        if (operResult.isSuccess()) {
            this.getView().showSuccessNotification(ModelLang.settleSuccess());
        } else {
            HashMap<Long, String> billNos = new HashMap<Long, String>(16);
            List<DynamicObject> bills = this.getSelectedBill(this.getBillType());
            for (DynamicObject bill : bills) {
                billNos.put(DynamicObjectUtil.getPkValue(bill), bill.getString("billno"));
            }
            PageShowHelper.showOperResult(this.getView(), operResult.getFailReasonsWithNo(billNos));
        }
    }

    public void showSettleOperateResult(SettleOperResult operResult, Map<Long, String> billInfo) {
        if (operResult == null) {
            return;
        }
        if (operResult.isSuccess()) {
            this.getView().showSuccessNotification(ModelLang.settleSuccess());
        } else {
            HashMap<Long, String> billNos = new HashMap<Long, String>(16);
            List<DynamicObject> bills = this.getSelectedBill(this.getBillType());
            for (DynamicObject bill : bills) {
                billNos.put(DynamicObjectUtil.getPkValue(bill), bill.getString("billno"));
            }
            if (!billInfo.isEmpty()) {
                billNos.putAll(billInfo);
            }
            PageShowHelper.showOperResult(this.getView(), operResult.getFailReasonsWithNo(billNos));
        }
    }

    protected void executeActions(ISMRequestContext reqContext, List<AbstractSettleAction> actions) {
        SettleActionProcessor.build(actions, this.getServiceContext()).doProcess(reqContext);
    }
}

