/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.dynpage.validate;

import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.consts.BOSExtPackage;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.ConvertFuncLoader;
import kd.bos.entity.function.BillFuncTypesLoader;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.metadata.entity.validation.ValidationType;
import kd.bos.metadata.entity.validation.ValidationTypeLoader;
import kd.bos.metadata.entity.validation.ValidationTypes;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.formplugin.dynpage.validate.AbstractIsmFuncValidateFormPlugin;

public class IsmBotpFunctionCheckEdit
extends AbstractIsmFuncValidateFormPlugin {
    private static final String BUTTON_FUNCTION_LOAD = "load";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_FUNCTION_LOAD});
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        switch (key = FormUtils.getControlEventKey(e)) {
            case "load": {
                this.functionLoad();
                break;
            }
        }
    }

    private void functionLoad() {
        FunctionType type;
        int[] rowindexes;
        List types = new ArrayList(32);
        List typelist = new ArrayList(32);
        Object value = this.getModel().getValue("funcselecttype");
        if ("0".equals(value)) {
            types = this.getFromBotp().getFunctionTypes();
        } else if ("1".equals(value)) {
            types = this.getFromFormula().getFunctionTypes();
        } else if ("2".equals(value)) {
            types = this.getBizCloudFromFunc().getFunctionTypes();
        } else if ("3".equals(value)) {
            types = this.getBizCloudFromBOTP().getFunctionTypes();
        } else if ("4".equals(value)) {
            ValidationTypes vtypes = ValidationTypeLoader.load();
            typelist = vtypes.getTypes();
        } else if ("5".equals(value)) {
            String[] extPack;
            ArrayList<IDataEntityType> arrayList = new ArrayList<IDataEntityType>();
            arrayList.add(OrmUtils.getDataEntityType(ValidationType.class));
            arrayList.add(OrmUtils.getDataEntityType(ValidationTypes.class));
            DcxmlSerializer ser = new DcxmlSerializer(arrayList);
            for (String cloudNumber : extPack = BOSExtPackage.getExtPackageNumbers()) {
                ValidationTypes t;
                URL url = ValidationTypes.class.getResource("/ValidationTypes_" + cloudNumber.toLowerCase() + ".xml");
                if (url == null || (t = (ValidationTypes)ser.deserialize(url, null)) == null) continue;
                typelist.addAll(t.getTypes());
            }
        } else if ("6".equals(value)) {
            String billType = this.getBillType();
            String appId = EntityMetadataCache.getDataEntityType((String)billType).getAppId();
            ValidationTypes vtypes = ValidationTypeLoader.load((String)appId, (String)billType, (String)"unaudit");
            typelist = vtypes.getTypes();
        }
        this.getModel().deleteEntryData("func");
        if (!types.isEmpty()) {
            rowindexes = this.getModel().batchCreateNewEntryRow("func", types.size());
            for (int i = 0; i < rowindexes.length; ++i) {
                int rowIndex = rowindexes[i];
                type = (FunctionType)types.get(i);
                this.getModel().setValue("funcid", (Object)type.getId(), rowIndex);
                this.getModel().setValue("funcgroupid", (Object)type.getGroupId(), rowIndex);
                this.getModel().setValue("funcname", (Object)type.getName(), rowIndex);
                this.getModel().setValue("funcdescript", (Object)type.getDesc(), rowIndex);
            }
        }
        if (!typelist.isEmpty()) {
            rowindexes = this.getModel().batchCreateNewEntryRow("func", typelist.size());
            for (int i = 0; i < typelist.size(); ++i) {
                int rowIndex = rowindexes[i];
                type = (ValidationType)typelist.get(i);
                this.getModel().setValue("funcid", (Object)type.getId(), rowIndex);
                this.getModel().setValue("funcgroupid", (Object)type.getAppNumbers(), rowIndex);
                this.getModel().setValue("funcname", (Object)type.getName(), rowIndex);
                this.getModel().setValue("funcdescript", (Object)type.getDesc(), rowIndex);
            }
        }
    }

    private FunctionTypes getFromBotp() {
        FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
        FunctionTypes cloudFunc = ConvertFuncLoader.loadBizCloudFuncTypes();
        functionTypes.getFunctionGroups().addAll(cloudFunc.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(cloudFunc.getFunctionTypes());
        return functionTypes;
    }

    private FunctionTypes getFromFormula() {
        return FunctionTypes.get();
    }

    private FunctionTypes getBizCloudFromBOTP() {
        return ConvertFuncLoader.loadBizCloudFuncTypes();
    }

    private FunctionTypes getBizCloudFromFunc() {
        return BillFuncTypesLoader.loadBizCloudFuncTypes();
    }
}

