/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.dynpage.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.form.MessageTypes;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.business.action.SettleActionFactory;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.log.PricingTypeLogHandler;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.common.model.mapper.DynamicObjectCacheMapper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.formplugin.dynpage.validate.AbstractIsmFuncValidateFormPlugin;
import kd.scmc.ism.lang.FormLang;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;

public class IsmFuncPricingValidateEdit
extends AbstractIsmFuncValidateFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnprice"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = FormUtils.getControlEventKey(evt);
        if ("btnprice".equals(key)) {
            this.doPricingValidate();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("pricing".equals(itemKey)) {
            this.doPricingValidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPricingValidate() {
        this.getModel().deleteEntryData("pricingentity");
        try {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billlist");
            int[] selectRowIndex = entryGrid.getSelectRows();
            List<DynamicObject> selectedBill = this.getSelectedBill(this.getBillType());
            if (CommonUtils.collectionIsEmpty(selectedBill)) {
                if (selectRowIndex.length == 1) {
                    this.getView().showErrorNotification(FormLang.billNotExist(selectRowIndex[0] + 1));
                } else {
                    this.getView().showMessage(FormLang.allFail(), this.getBillNotExistErrorInfo(selectRowIndex), MessageTypes.Default);
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabap", "pricefunction"});
                return;
            }
            ISMRequestContext requestContext = this.buildRequest(selectedBill);
            this.showResult(requestContext, selectedBill, selectRowIndex);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabap", "pricefunction"});
        }
        catch (KDException e) {
            this.getView().showTipNotification(e.getMessage());
        }
        finally {
            this.getView().updateView("pricingentity");
            this.getView().updateView("pricingsubentity");
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("pricefunction");
        }
    }

    public ISMRequestContext buildRequest(Collection<DynamicObject> bills) {
        ISMRequestContext requestContext;
        HashSet<Long> billIds = new HashSet<Long>(16);
        for (DynamicObject bill : bills) {
            billIds.add(bill.getLong("id"));
        }
        DynamicObject[] settleLogs = BusinessDataServiceHelper.load((String)"ism_settlelog", (String)"sourceid, biztraceno, groupkey,entryentity.settlebilltype, entryentity.settlebilltype, entryentity.settlebillid, entryentity.settlebillno,entryentity.settlepath, entryentity.esupsettleorg, entryentity.edemandorg, entryentity.settlerelation, entryentity.relationtype, entryentity.bizflow", (QFilter[])new QFilter("sourceid", "in", billIds).and("createstatus", "in", (Object)new String[]{"E", "A"}).toArray());
        if (settleLogs.length == 0) {
            requestContext = ISMRequestContext.create(this.getBillType(), billIds);
            this.executeActions(requestContext, SettleActionFactory.getGenAndPriceActions());
            return requestContext;
        }
        requestContext = this.existBillRePrice(bills, Arrays.asList(settleLogs));
        this.executeActions(requestContext, SettleActionFactory.getPriceActions());
        return requestContext;
    }

    private ISMRequestContext existBillRePrice(Collection<DynamicObject> bills, Collection<DynamicObject> settleLogs) {
        ISMRequestContext requestContext = ISMRequestContext.create();
        for (DynamicObject bill : bills) {
            SettleBillModel billModel = SettleBillModel.build(bill, this.getServiceContext().getMapCfg());
            requestContext.addSrcBillModel(billModel);
        }
        Map<Long, DynamicObject> entryPaths = this.getPathEntyMap(settleLogs);
        HashMap<String, SettleBillModel> srcBills = new HashMap<String, SettleBillModel>(16);
        HashMap<String, Long> supBillsInfos = new HashMap<String, Long>(16);
        HashMap<String, Long> demBillsInfos = new HashMap<String, Long>(16);
        HashMap<String, CoupleSettleBillsModel> cpModels = new HashMap<String, CoupleSettleBillsModel>(16);
        HashMap<String, Set<Long>> needQueryBillInfo = new HashMap<String, Set<Long>>(16);
        for (DynamicObject settleLog : settleLogs) {
            long srcBillId = settleLog.getLong("sourceid");
            for (DynamicObject entry : settleLog.getDynamicObjectCollection("entryentity")) {
                String stbillEntity = entry.getDynamicObject("settlebilltype").getString("number");
                long stBillId = entry.getLong("settlebillid");
                long spathId = entry.getLong("settlepath");
                long supOrgId = DynamicObjectUtil.getPkValue(entry.getDynamicObject("esupsettleorg"));
                long demOrgId = DynamicObjectUtil.getPkValue(entry.getDynamicObject("edemandorg"));
                String cacheKey = "" + srcBillId + "-" + spathId + "-" + supOrgId + "-" + demOrgId;
                srcBills.put(cacheKey, requestContext.getSrcBillModel(srcBillId));
                String relType = entry.getString("relationtype");
                if ("supplier".equals(relType)) {
                    supBillsInfos.put(cacheKey, stBillId);
                } else {
                    if (!"demand".equals(relType)) continue;
                    demBillsInfos.put(cacheKey, stBillId);
                }
                CoupleSettleBillsModel cpModel = (CoupleSettleBillsModel)cpModels.get(cacheKey);
                if (cpModel == null) {
                    cpModel = CoupleSettleBillsModel.build();
                    cpModel.setSupplierId(supOrgId);
                    cpModel.setDemandId(demOrgId);
                    cpModel.setEntrySettleRelation(entryPaths.get(spathId));
                    cpModels.put(cacheKey, cpModel);
                }
                CommonUtils.mapGetSetValue(needQueryBillInfo, stbillEntity).add(stBillId);
            }
            requestContext.getAllLogs().put(srcBillId, SettleLogHandler.load(settleLog));
        }
        if (needQueryBillInfo.isEmpty()) {
            return requestContext;
        }
        Map<Long, SettleBillModel> sdbillModels = this.getSupAndDemModels(needQueryBillInfo);
        for (Map.Entry cpModelEntry : cpModels.entrySet()) {
            String cacheKey = (String)cpModelEntry.getKey();
            CoupleSettleBillsModel model = (CoupleSettleBillsModel)cpModelEntry.getValue();
            model.init((SettleBillModel)srcBills.get(cacheKey), sdbillModels.get(supBillsInfos.get(cacheKey)), sdbillModels.get(demBillsInfos.get(cacheKey)));
            requestContext.addSupDemBillInfo(model);
        }
        return requestContext;
    }

    private Map<Long, DynamicObject> getPathEntyMap(Collection<DynamicObject> settleLogs) {
        HashMap<Long, DynamicObject> entryPaths = new HashMap<Long, DynamicObject>(settleLogs.size());
        HashSet<Long> relations = new HashSet<Long>(settleLogs.size());
        for (DynamicObject settleLog : settleLogs) {
            for (DynamicObject entry : settleLog.getDynamicObjectCollection("entryentity")) {
                relations.add(DynamicObjectUtil.getPkValue(entry.getDynamicObject("settlerelation")));
            }
        }
        Map relationObjs = BusinessDataServiceHelper.loadFromCache((String)"ism_settlerelations", (QFilter[])new QFilter("id", "in", relations).toArray());
        for (DynamicObject relationObj : relationObjs.values()) {
            DynamicObjectCollection entries = relationObj.getDynamicObjectCollection("settlerelationdetail");
            for (DynamicObject entry : entries) {
                entryPaths.put(DynamicObjectUtil.getPkValue(entry), entry);
            }
        }
        return entryPaths;
    }

    private Map<Long, SettleBillModel> getSupAndDemModels(Map<String, Set<Long>> needQueryBillInfo) {
        HashMap<Long, SettleBillModel> sdbillModels = new HashMap<Long, SettleBillModel>(16);
        for (Map.Entry<String, Set<Long>> billInfo : needQueryBillInfo.entrySet()) {
            String entity = billInfo.getKey();
            Set<Long> values = billInfo.getValue();
            Map settleBills = BusinessDataServiceHelper.loadFromCache((String)entity, (QFilter[])new QFilter("id", "in", values).toArray());
            for (DynamicObject stbill : settleBills.values()) {
                sdbillModels.put(stbill.getLong("id"), SettleBillModel.build(stbill, this.getServiceContext().getMapCfg()));
            }
        }
        return sdbillModels;
    }

    private void showResult(ISMRequestContext requestContext, List<DynamicObject> selectedBill, int[] selectedRowIndex) {
        DynamicObjectCacheMapper cacheMapper = this.getServiceContext().getService(DynamicObjectCacheMapper.class);
        List<CoupleSettleBillsModel> supDemBillInfos = requestContext.getSupDemBillInfos();
        Map<Long, String> billMap = this.getBillIdAndNo(selectedBill);
        boolean showSuccess = true;
        String errorInfo = this.getErrorInfo(billMap, supDemBillInfos);
        if (StringUtils.isNotEmpty((CharSequence)errorInfo)) {
            showSuccess = false;
            if (supDemBillInfos.isEmpty()) {
                if (selectedRowIndex.length == 1) {
                    this.getView().showErrorNotification(FormLang.pricingValidateFail(selectedRowIndex[0] + 1));
                } else {
                    this.getView().showMessage(FormLang.allFail(), errorInfo, MessageTypes.Default);
                }
                return;
            }
            this.getView().showMessage(FormLang.partFail(), errorInfo, MessageTypes.Default);
        }
        PricingTypeLogHandler currencyHandler = requestContext.getPricingLogHandler().getTypeLogHandler("currency");
        PricingTypeLogHandler exrateDateHandler = requestContext.getPricingLogHandler().getTypeLogHandler("exrate");
        PricingTypeLogHandler priceHandler = requestContext.getPricingLogHandler().getTypeLogHandler("price");
        PricingTypeLogHandler taxrateHandler = requestContext.getPricingLogHandler().getTypeLogHandler("taxrate");
        for (CoupleSettleBillsModel billsModel : supDemBillInfos) {
            HashMap<Long, Integer> billIdToEntry = new HashMap<Long, Integer>(supDemBillInfos.size());
            for (SettleBillModel billModel : billsModel.getModels()) {
                int i = this.getModel().createNewEntryRow("pricingentity");
                long id = billModel.getId();
                long srcBillId = ((SettleBillModel)billsModel.getSrcBillModel()).getId();
                this.getModel().setValue("srcbillid", (Object)billMap.get(srcBillId), i);
                this.getModel().setValue("pricingbillid", (Object)id, i);
                this.getModel().setValue("pricingbllno", billModel.getObj().get("billno"), i);
                this.getModel().setValue("pricingbillentity", (Object)billModel.getBillEntityType(), i);
                this.getModel().setValue("pricingsettlecurrency", (Object)billsModel.getSettleCurrencyId(), i);
                this.getModel().setValue("pricingexratedate", (Object)billsModel.getExRateDate(), i);
                StringBuilder headInfo = new StringBuilder();
                if (!billsModel.isPricing()) {
                    headInfo.append(billsModel.getPricedReason());
                    headInfo.append("\n");
                } else {
                    List<String> curInfo = currencyHandler.getLogInfos().get(billsModel.getId());
                    headInfo.append(PricingLang.currencyInfo(curInfo));
                    headInfo.append("\n");
                    List<String> exrateInfo = exrateDateHandler.getLogInfos().get(billsModel.getId());
                    headInfo.append(PricingLang.exrateDateInfo(exrateInfo));
                    headInfo.append("\n");
                }
                String pricingLog = headInfo.toString();
                this.getModel().setValue("pricinglog", (Object)pricingLog, i);
                this.getModel().setValue("pricinglog_tag", (Object)pricingLog, i);
                if (!pricingLog.contains(PricingLang.priceBlueBill())) {
                    this.getModel().setValue("pricingpricerule", (Object)billsModel.getPriceRuleObj(), i);
                }
                billIdToEntry.put(id, i);
            }
            List<CoupleSettleBillEntriesModel> cpEntries = billsModel.getEntries();
            for (CoupleSettleBillEntriesModel cpEntryModel : cpEntries) {
                for (SettleBillEntryModel entryModel : cpEntryModel.getModels()) {
                    long id = entryModel.getBillModel().getId();
                    Integer i = (Integer)billIdToEntry.get(id);
                    DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("pricingsubentity", i.intValue());
                    DynamicObject pricingSub = value.addNew();
                    pricingSub.set("pricingentryid", (Object)entryModel.getId());
                    pricingSub.set("pricingseq", entryModel.getObj().get("seq"));
                    DynamicObject materialObj = (DynamicObject)entryModel.getValue("material");
                    if (materialObj != null) {
                        DynamicObject material = DynamicObjectUtil.getMaterialMasterObject(materialObj);
                        pricingSub.set("pricingmaterial", (Object)material);
                    }
                    pricingSub.set("pricingcurrency", (Object)cacheMapper.get("bd_currency", cpEntryModel.getPriceCurrencyId()));
                    pricingSub.set("pricingunit", (Object)cacheMapper.get("bd_measureunits", cpEntryModel.getPriceUnit()));
                    pricingSub.set("pricingprice", (Object)cpEntryModel.getRePrice());
                    pricingSub.set("pricingtaxprice", (Object)cpEntryModel.getRePriceWithTax());
                    pricingSub.set("pricingtaxrate", (Object)cacheMapper.get("bd_taxrate", cpEntryModel.getTaxRateId()));
                    pricingSub.set("pricingunit2", entryModel.getValue("unit"));
                    pricingSub.set("pricingcalprice", (Object)cpEntryModel.getCalPrice());
                    pricingSub.set("pricingcaltaxprice", (Object)cpEntryModel.getCalPriceWithTax());
                    StringBuilder entryInfo = new StringBuilder();
                    if (!cpEntryModel.isPricing()) {
                        entryInfo.append(cpEntryModel.getPricedReason());
                        entryInfo.append("\n");
                    } else {
                        List<String> priceInfo = priceHandler.getLogInfos().get(cpEntryModel.getId());
                        entryInfo.append(PricingLang.priceInfo(priceInfo));
                        entryInfo.append("\n");
                        List<String> taxrateInfo = taxrateHandler.getLogInfos().get(cpEntryModel.getId());
                        entryInfo.append(PricingLang.taxRateInfo(taxrateInfo));
                        entryInfo.append("\n");
                    }
                    pricingSub.set("pricingentrylog", (Object)entryInfo.toString());
                    pricingSub.set("pricingentrylog_tag", (Object)entryInfo.toString());
                }
            }
        }
        if (showSuccess) {
            this.getView().showSuccessNotification(ModelLang.settleSuccess());
        }
        this.getView().updateView("pricingentity");
    }

    private String getErrorInfo(Map<Long, String> selectedBill, List<CoupleSettleBillsModel> supDemBillInfos) {
        Map<Long, String> notExistBill = this.getSelectedBillNotExist(selectedBill);
        HashSet<Long> hasSettleBillIds = new HashSet<Long>(supDemBillInfos.size());
        for (CoupleSettleBillsModel coupleSettleBillsModel : supDemBillInfos) {
            hasSettleBillIds.add(((SettleBillModel)coupleSettleBillsModel.getSrcBillModel()).getId());
        }
        ArrayList<String> noSettleBillNo = new ArrayList<String>(16);
        for (Map.Entry<Long, String> entry : selectedBill.entrySet()) {
            if (hasSettleBillIds.contains(entry.getKey())) continue;
            noSettleBillNo.add(entry.getValue());
        }
        StringBuilder stringBuilder = new StringBuilder();
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        Iterator<Object> iterator = notExistBill.keySet().iterator();
        while (iterator.hasNext()) {
            long l = iterator.next();
            int rowIndex = (int)l;
            treeMap.put(rowIndex, FormLang.billNotExist(rowIndex + 1));
        }
        if (!noSettleBillNo.isEmpty()) {
            List<Integer> noSettleBillIndex = this.getBillIndex(noSettleBillNo);
            for (int rowIndex : noSettleBillIndex) {
                treeMap.put(rowIndex, FormLang.pricingValidateFail(rowIndex + 1));
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            stringBuilder.append((String)entry.getValue());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String getBillNotExistErrorInfo(int[] rowIndex) {
        StringBuilder errorInfo = new StringBuilder();
        for (int index : rowIndex) {
            errorInfo.append(FormLang.billNotExist(index));
            errorInfo.append("\n");
        }
        return errorInfo.toString();
    }
}

