/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.dynpage.validate;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.fs.util.StringUtils;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.business.selectlistener.billmainentity.BillEnableSettleJudge;
import kd.scmc.ism.business.utils.BizLockUtils;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.formplugin.dynpage.validate.AbstractIsmFuncValidateFormPlugin;
import kd.scmc.ism.lang.FormLang;

public class IsmFuncValidateBaseFunctionEdit
extends AbstractIsmFuncValidateFormPlugin {
    private static final Log log = LogFactory.getLog(IsmFuncValidateBaseFunctionEdit.class);

    public void registerListener(EventObject e) {
        FormUtils.addF7Listener(BillEnableSettleJudge.getInstance(), this, "billtype");
        this.addClickListeners(new String[]{"billno"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "checkbill": {
                this.clickCheckBill();
                break;
            }
            case "checksettlelog": {
                this.clickCheckSettleLog();
                break;
            }
            case "releasebizlock": {
                this.clickRealseLock();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("billno".equals(key)) {
            String billType;
            try {
                billType = this.getBillType();
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
                return;
            }
            ListShowParameter basedataF7Param = ShowFormHelper.createShowListForm((String)billType, (boolean)false);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billType);
            basedataF7Param.setAppId(entityType.getAppId());
            basedataF7Param.setMultiSelect(true);
            basedataF7Param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "billNoSelectF7"));
            this.getView().showForm((FormShowParameter)basedataF7Param);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (key.equals("billtype")) {
            this.updateSettleStatusByBillType(newValue);
        } else if (key.equals("billno")) {
            Object billType = this.getModel().getValue("billtype");
            if (billType == null) {
                this.getView().showTipNotification(FormLang.plsSelect(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61", (String)"IsmFuncPricingValidateEdit_4", (String)"scmc-ism-form", (Object[])new Object[0])));
                return;
            }
            int rowIndex = changeData.getRowIndex();
            this.updateSettleStatusByBillNum(newValue, rowIndex);
        }
    }

    private void clickCheckBill() {
        try {
            DynamicObject bill = this.getCurrentSelectBill(this.getBillType());
            PageShowHelper.showBillEdit(this.getView(), bill);
        }
        catch (KDBizException e) {
            String errorCode = e.getErrorCode().getCode();
            String msg = e.getMessage();
            if ("ISMEC-BZ0002".equals(errorCode)) {
                this.getView().showErrorNotification(msg);
            }
            this.getView().showTipNotification(msg);
        }
    }

    private void clickRealseLock() {
        String billType = this.getBillType();
        if (billType == null) {
            return;
        }
        List<DynamicObject> selectedBill = this.getSelectedBill(billType);
        if (selectedBill == null || selectedBill.isEmpty()) {
            return;
        }
        Set<Long> ids = DynamicObjectUtil.getDynamicObjectIds(selectedBill);
        BizLockUtils.releaseLock(ids, "SETTLE");
        this.getView().showSuccessNotification(FormLang.releaseLockFinish());
    }

    private void clickCheckSettleLog() {
        try {
            String billType = this.getBillType();
            DynamicObject bill = this.getCurrentSelectBill(billType);
            DynamicObject log = QueryServiceHelper.queryOne((String)"ism_settlelog", (String)"id", (QFilter[])new QFilter("sourceid", "=", (Object)bill.getLong("id")).toArray());
            if (log == null) {
                this.getView().showTipNotification(FormLang.billNotExistSettleLog());
                return;
            }
            PageShowHelper.showBaseEdit(this.getView(), "ism_settlelog", log.get("id"));
        }
        catch (KDBizException e) {
            String errorCode = e.getErrorCode().getCode();
            String msg = e.getMessage();
            if ("ISMEC-BZ0002".equals(errorCode)) {
                this.getView().showErrorNotification(msg);
            }
            this.getView().showTipNotification(msg);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "billNoSelectF7": {
                this.billNoSelectF7(e.getReturnData());
                break;
            }
        }
    }

    private void billNoSelectF7(Object returnObj) {
        if (returnObj == null) {
            return;
        }
        ListSelectedRowCollection selectRows = (ListSelectedRowCollection)returnObj;
        if (selectRows.isEmpty()) {
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex("billlist");
        if (selectRows.size() == 1) {
            String billNo = selectRows.get(0).getBillNo();
            this.getModel().setValue("billno", (Object)billNo, index);
        } else {
            this.setMultiRowValue(selectRows, index);
        }
    }

    private void setMultiRowValue(ListSelectedRowCollection selectRows, int index) {
        int selectedRowsSize = selectRows.size();
        if (selectedRowsSize > 1000) {
            this.getView().showTipNotification(FormLang.tooMuchData(1000));
        }
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        this.addEntryRow(tableValueSetter);
        String selectedBillNo = selectRows.get(0).getBillNo();
        if (StringUtils.isEmpty((String)selectedBillNo)) {
            Object[] ids = this.getBillIdFilter(selectRows);
            DataSet billDatas = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.getBillType(), (String)"billno", (QFilter[])new QFilter("id", "in", (Object)ids).toArray(), null);
            while (billDatas.hasNext()) {
                Row row = billDatas.next();
                tableValueSetter.addField("billno", new Object[]{row.getString("billno")});
            }
        } else {
            for (int i = 0; i < selectedRowsSize; ++i) {
                String billNo = selectRows.get(i).getBillNo();
                tableValueSetter.addField("billno", new Object[]{billNo});
            }
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("billlist", tableValueSetter);
        this.updateSettleStatusByBillType(this.getModel().getValue("billtype"));
        this.getView().updateView("billlist");
    }

    private void updateSettleStatusByBillType(Object newValue) {
        DynamicObjectCollection billList = this.getModel().getEntryEntity("billlist");
        int count = billList.size();
        Map<String, List<Integer>> billNoIndexMap = this.getAllBillListNum(billList);
        Set<String> entryBillNos = billNoIndexMap.keySet();
        if (newValue == null || CommonUtils.collectionIsEmpty(entryBillNos)) {
            this.updateSettleStatus("", count);
            return;
        }
        Map<Long, String> billMap = this.getAllBillListInfo(((DynamicObject)newValue).getString("number"), entryBillNos);
        Set<Long> billIds = billMap.keySet();
        Set billNumSet = billMap.values().stream().collect(Collectors.toSet());
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            String curRowBillNo = (String)this.getModel().getValue("billno", i);
            if (!StringUtils.isEmpty((String)curRowBillNo) && billNumSet.contains(curRowBillNo)) continue;
            indexList.add(i);
        }
        this.updateSettleStatus("", indexList.toArray());
        DataSet settleDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ism_settlelog", (String)"sourceid,createstatus", (QFilter[])new QFilter("sourceid", "in", billIds).toArray(), (String)"sourceid");
        while (settleDataSet.hasNext()) {
            Row settleLog = settleDataSet.next();
            long sourceId = settleLog.getLong("sourceid");
            String createStatus = settleLog.getString("createstatus");
            String billNo = billMap.get(sourceId);
            String settleStatus = this.getSettleStatus(createStatus);
            this.updateSettleStatus(settleStatus, billNoIndexMap.get(billNo).toArray());
            billNumSet.remove(billNo);
        }
        if (CommonUtils.collectionIsNotEmpty(billNumSet)) {
            ArrayList undoList = new ArrayList();
            for (String billNo : billNumSet) {
                undoList.addAll(billNoIndexMap.get(billNo));
            }
            this.updateSettleStatus("1", undoList.toArray());
        }
        this.getView().updateView("billlist");
    }

    private void updateSettleStatusByBillNum(Object newValue, int rowIndex) {
        DynamicObject currentBill = this.getChangeBill(rowIndex);
        String settleStatus = "";
        if (StringUtils.isNotEmpty((String)((String)newValue)) && currentBill != null) {
            DynamicObject settleLog = QueryServiceHelper.queryOne((String)"ism_settlelog", (String)"createstatus", (QFilter[])new QFilter("sourceid", "=", (Object)currentBill.getLong("id")).toArray());
            if (settleLog == null) {
                settleStatus = "1";
            } else {
                String createStatus = settleLog.getString("createstatus");
                settleStatus = this.getSettleStatus(createStatus);
            }
        }
        this.updateSettleStatus(settleStatus, new Object[]{rowIndex});
        this.getView().updateView("billlist", rowIndex);
        this.setSelectedRows(rowIndex);
    }

    private Map<String, List<Integer>> getAllBillListNum(DynamicObjectCollection billList) {
        HashMap<String, List<Integer>> result = new HashMap<String, List<Integer>>(16);
        for (int i = 0; i < billList.size(); ++i) {
            DynamicObject bill = (DynamicObject)billList.get(i);
            String billNo = bill.getString("billno");
            if (!StringUtils.isNotEmpty((String)billNo)) continue;
            List indexList = result.getOrDefault(billNo, new ArrayList(1));
            indexList.add(i);
            result.put(billNo, indexList);
        }
        return result;
    }

    private Map<Long, String> getAllBillListInfo(String entryName, Set<String> entryBillNos) {
        QFilter qFilter = new QFilter("billno", "in", entryBillNos);
        DataSet billDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entryName, (String)"id,billno", (QFilter[])qFilter.toArray(), (String)"id");
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        while (billDataSet.hasNext()) {
            Row row = billDataSet.next();
            long billId = row.getLong("id");
            String billNo = row.getString("billno");
            result.put(billId, billNo);
        }
        return result;
    }

    private DynamicObject getChangeBill(int index) {
        try {
            String billType = this.getBillType();
            List<DynamicObject> selectedBill = this.getBill(billType, index);
            if (!selectedBill.isEmpty()) {
                return selectedBill.get(0);
            }
        }
        catch (KDBizException e) {
            log.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)e)));
            return null;
        }
        return null;
    }

    private void updateSettleStatus(String value, int count) {
        this.getModel().beginInit();
        for (int i = 0; i < count; ++i) {
            this.getModel().setValue("settlestatus", (Object)value, i);
        }
        this.getModel().endInit();
    }

    private void updateSettleStatus(String value, Object[] index) {
        this.getModel().beginInit();
        for (Object rowIndex : index) {
            this.getModel().setValue("settlestatus", (Object)value, ((Integer)rowIndex).intValue());
        }
        this.getModel().endInit();
    }

    private String getSettleStatus(String createStatus) {
        if ("D".equals(createStatus)) {
            return "1";
        }
        if ("A".equals(createStatus) || "E".equals(createStatus) || "N".equals(createStatus)) {
            return "2";
        }
        return "3";
    }

    private void setSelectedRows(int ... rowIndex) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("billlist");
        entryGrid.selectRows(rowIndex, rowIndex[0]);
    }

    private Object[] getBillIdFilter(ListSelectedRowCollection selectRows) {
        int maxLine = selectRows.size() > 1000 ? 1000 : selectRows.size();
        Object[] pkValue = new Object[maxLine];
        for (int i = 0; i < maxLine; ++i) {
            pkValue[i] = selectRows.get(i).getPrimaryKeyValue();
        }
        return pkValue;
    }

    private void addEntryRow(TableValueSetter tableValueSetter) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("billlist");
        for (DynamicObject bill : dynamicObjects) {
            String billNo = bill.getString("billno");
            if (!StringUtils.isNotEmpty((String)billNo)) continue;
            tableValueSetter.addField("billno", new Object[]{billNo});
        }
        this.getModel().deleteEntryData("billlist");
    }
}

