/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.dynpage.validate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.model.settlebill.SettleBillChecker;
import kd.scmc.ism.common.model.settlebill.SettleBillDeleter;
import kd.scmc.ism.common.model.settlebill.SettleBillGenerator;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.formplugin.dynpage.validate.AbstractIsmFuncValidateFormPlugin;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.mservice.settlebill.SettleBillServiceImpl;

public class IsmFuncValidateSettleEdit
extends AbstractIsmFuncValidateFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"generatesettle", "deletesettle", "validatesettle", "checksettle"});
    }

    public void click(EventObject e) {
        super.click(e);
        String key = FormUtils.getControlEventKey(e);
        String billtype = this.getBillType();
        switch (key) {
            case "generatesettle": {
                this.clickGenereateSettle(billtype);
                break;
            }
            case "deletesettle": {
                this.clickDeleteSettle(billtype);
                break;
            }
            case "validatesettle": {
                this.clickValidateSettle(billtype);
                break;
            }
            case "checksettle": {
                this.clickCheckSettle(billtype);
                break;
            }
        }
    }

    private void clickDeleteSettle(String billtype) {
        List<DynamicObject> bills = this.getSelectedBill(billtype);
        if (bills.isEmpty()) {
            return;
        }
        ArrayList<Long> billIds = new ArrayList<Long>(bills.size());
        for (DynamicObject bill : bills) {
            billIds.add(bill.getLong("id"));
        }
        SettleBillDeleter deleter = new SettleBillDeleter();
        SettleOperResult result = deleter.executeDeleteBySourceBills(billIds);
        this.showSettleOperResult(result);
    }

    private void clickGenereateSettle(String billtype) {
        List<DynamicObject> bills = this.getSelectedBill(billtype);
        ArrayList<Long> billIds = new ArrayList<Long>(bills.size());
        for (DynamicObject bill : bills) {
            billIds.add(bill.getLong("id"));
        }
        SettleBillGenerator neoGenerator = new SettleBillGenerator();
        SettleOperResult result = neoGenerator.generate(billtype, billIds);
        this.showSettleOperResult(result);
    }

    private void clickValidateSettle(String billtype) {
        Set<Long> noSettleIds;
        List<DynamicObject> bills = this.getSelectedBill(billtype);
        Set<Long> billIds = DynamicObjectUtil.getDynamicObjectIds(bills);
        Map<String, Set<Long>> validateSettle = new SettleBillServiceImpl().validateSettle(Collections.singletonMap(billtype, billIds));
        SettleOperResult result = new SettleOperResult();
        Set<Long> allFaildIds = validateSettle.get("settlefail");
        if (!allFaildIds.isEmpty()) {
            result.batchAddFailInfo(allFaildIds, ModelLang.settleFail());
        }
        if (!(noSettleIds = validateSettle.get("nosettle")).isEmpty()) {
            result.batchAddFailInfo(noSettleIds, ModelLang.noSettle());
        }
        this.showSettleOperResult(result);
    }

    private void clickCheckSettle(String billtype) {
        List<DynamicObject> bills = this.getSelectedBill(billtype);
        SettleBillChecker checker = new SettleBillChecker();
        SettleOperResult result = checker.check(bills);
        this.showSettleOperResult(result);
    }
}

