/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.formplugin.template;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.ism.common.errocode.ISMErrorCode;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.lang.FormLang;

public abstract class AbstractISMFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void addF7Listener(String ... f7Name) {
        this.addF7Listener(this, f7Name);
    }

    public void addF7Listener(BeforeF7SelectListener listener, String ... f7Name) {
        FormUtils.addF7Listener(listener, this, f7Name);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        try {
            QFilter filter = this.buildF7SelectFilter(event.getProperty().getName(), event);
            if (filter != null) {
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
        catch (KDBizException e) {
            event.setCancel(true);
            ErrorCode errorCode = e.getErrorCode();
            if ("ISMEC-BZ0001".equals(errorCode.getCode())) {
                if (!event.getSourceMethod().equals("setItemByNumber")) {
                    this.getView().showErrorNotification(errorCode.getMessage());
                }
            }
            throw e;
        }
    }

    protected QFilter buildF7SelectFilter(String key, BeforeF7SelectEvent event) {
        return null;
    }

    protected Object getValue(String key) {
        Object value = this.getModel().getValue(key);
        if (value == null) {
            this.keyNoValue(key);
        }
        return value;
    }

    protected String getStrValue(String key) {
        String value = (String)this.getModel().getValue(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.keyNoValue(key);
        }
        return value;
    }

    protected Object getValue(String key, int index) {
        Object value = this.getModel().getValue(key, index);
        if (value == null) {
            this.entryKetNoValue(key, index);
        }
        return value;
    }

    protected String getStrValue(String key, int index) {
        String value = (String)this.getModel().getValue(key, index);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.entryKetNoValue(key, index);
        }
        return value;
    }

    private void entryKetNoValue(String key, int index) {
        MainEntityType entityType = this.getModel().getDataEntityType();
        IDataEntityProperty findProperty = entityType.findProperty(key);
        throw new KDBizException(ISMErrorCode.nullValue(FormLang.PlsSelectIndex(findProperty.getDisplayName().getLocaleValue(), index)), new Object[0]);
    }

    private void keyNoValue(String key) {
        MainEntityType entityType = this.getModel().getDataEntityType();
        IDataEntityProperty findProperty = entityType.findProperty(key);
        throw new KDBizException(ISMErrorCode.nullValue(FormLang.plsSelect(findProperty.getDisplayName().getLocaleValue())), new Object[0]);
    }
}

