/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.batexec.handle.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.executor.JobClient;
import kd.scmc.ism.business.helper.JobHelper;
import kd.scmc.ism.lang.TaskLang;
import kd.scmc.ism.model.batexec.handle.IBizExecutor;
import kd.scmc.ism.task.InnerSettleExecuteTask;
import kd.scmc.ism.task.InnerSettleTask;

public class SettleBizAsyncExecutor
implements IBizExecutor<Long, String> {
    private final String entityType;

    public SettleBizAsyncExecutor(String entityType) {
        this.entityType = entityType;
    }

    @Override
    public String execute(List<Long> elements) {
        HashMap<String, String> jobParams = new HashMap<String, String>();
        jobParams.put("entityType", this.entityType);
        jobParams.put("ids", SerializationUtils.toJsonString(elements));
        JobInfo job = JobHelper.getJobInfo(InnerSettleTask.class, TaskLang.batchInnerSettleBack());
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setParams(jobParams);
        job.setRunConcurrently(true);
        return JobClient.dispatch((JobInfo)job);
    }

    @Override
    public String execute(Map<String, List<Long>> billInfo, String traceId) {
        HashMap<String, Object> jobParams = new HashMap<String, Object>();
        jobParams.put("entityType", billInfo);
        jobParams.put("traceid", traceId);
        JobInfo job = JobHelper.buildJobInfo(UUID.randomUUID().toString(), InnerSettleExecuteTask.class.getName(), ResManager.loadKDString((String)"\u7ec4\u7ec7\u95f4\u7ed3\u7b97", (String)"SettleProgressFormPlugin_7", (String)"scmc-ism-form", (Object[])new Object[0]), jobParams);
        job.setRunConcurrently(true);
        return JobClient.dispatch((JobInfo)job);
    }
}

