/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.bill.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.model.bill.ISettleBillModel;
import kd.scmc.ism.model.bill.impl.AbstractSettleBillModel;

public abstract class AbstractCoupleSettleBillsModel<T extends AbstractSettleBillModel>
implements ISettleBillModel {
    private boolean pricing = true;
    private String pricedReason = "";
    private T srcBillModel = null;
    private T supBillModel = null;
    private T demBillModel = null;

    public AbstractCoupleSettleBillsModel(T supBillModel, T demBillModel) {
        this.supBillModel = supBillModel;
        this.demBillModel = demBillModel;
    }

    @Override
    public Object getValue(String key) {
        if (this.supBillModel != null) {
            return this.supBillModel.getValue(key);
        }
        if (this.demBillModel != null) {
            return this.demBillModel.getValue(key);
        }
        return null;
    }

    @Override
    public void setValue(String key, Object value) {
        if (this.supBillModel != null) {
            this.supBillModel.setValue(key, value);
        }
        if (this.demBillModel != null) {
            this.demBillModel.setValue(key, value);
        }
    }

    public T getSrcBillModel() {
        return this.srcBillModel;
    }

    public T getSupBillModel() {
        return this.supBillModel;
    }

    public T getDemBillModel() {
        return this.demBillModel;
    }

    protected void setSrcBillModel(T srcBillModel) {
        this.srcBillModel = srcBillModel;
    }

    protected void setDemBillModel(T demBillModel) {
        this.demBillModel = demBillModel;
    }

    protected void setSupBillModel(T supBillModel) {
        this.supBillModel = supBillModel;
    }

    @Override
    public long getId() {
        if (this.supBillModel != null) {
            return ((AbstractSettleBillModel)this.supBillModel).getId();
        }
        if (this.demBillModel != null) {
            return ((AbstractSettleBillModel)this.demBillModel).getId();
        }
        return 0L;
    }

    @Override
    public String getBillEntityType() {
        StringBuilder cpBillEntityType = new StringBuilder();
        if (this.supBillModel != null) {
            cpBillEntityType.append(this.supBillModel.getBillEntityType());
        }
        cpBillEntityType.append(':');
        if (this.demBillModel != null) {
            cpBillEntityType.append(this.demBillModel.getBillEntityType());
        }
        return cpBillEntityType.toString();
    }

    protected void valueWriteBack() {
        if (this.supBillModel != null) {
            ((AbstractSettleBillModel)this.supBillModel).valueWriteBack();
        }
        if (this.demBillModel != null) {
            ((AbstractSettleBillModel)this.demBillModel).valueWriteBack();
        }
    }

    @Override
    public DynamicObject getObj() {
        if (this.supBillModel != null) {
            return ((AbstractSettleBillModel)this.supBillModel).getObj();
        }
        if (this.demBillModel != null) {
            return ((AbstractSettleBillModel)this.demBillModel).getObj();
        }
        return null;
    }

    public boolean isPricing() {
        return this.pricing;
    }

    public String getPricedReason() {
        return this.pricedReason;
    }

    public void markPriced(String pricedReason) {
        this.pricing = false;
        this.pricedReason = pricedReason;
    }

    public boolean isContain(long id) {
        return this.supBillModel != null && ((AbstractSettleBillModel)this.supBillModel).getId() == id || this.demBillModel != null && ((AbstractSettleBillModel)this.demBillModel).getId() == id;
    }

    public List<T> getModels() {
        ArrayList<T> bills = new ArrayList<T>(2);
        if (this.getSupBillModel() != null) {
            bills.add(this.getSupBillModel());
        }
        if (this.getDemBillModel() != null) {
            bills.add(this.getDemBillModel());
        }
        return bills;
    }
}

