/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.bill.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.model.assist.OrgAssistant;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.bill.impl.AbstractCoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.relation.RelationEntryModel;

public class CoupleSettleBillsModel
extends AbstractCoupleSettleBillsModel<SettleBillModel> {
    private List<CoupleSettleBillEntriesModel> entries = new ArrayList<CoupleSettleBillEntriesModel>(16);
    private Map<Long, CoupleSettleBillEntriesModel> entryModelMap = new HashMap<Long, CoupleSettleBillEntriesModel>(16);
    private Long supplierId = 0L;
    private Long demandId = 0L;
    private RelationEntryModel relEntryModel = null;
    private DynamicObject priceRuleObj = null;
    private Date exRateDate = null;
    private Long settleCurrencyId = 0L;

    public static CoupleSettleBillsModel build() {
        CoupleSettleBillsModel billModel = new CoupleSettleBillsModel(null, null);
        return billModel;
    }

    public void init(SettleBillModel srcBillModel, SettleBillModel supBillModel, SettleBillModel demBillModel) {
        this.setSupBillModel(supBillModel);
        this.setDemBillModel(demBillModel);
        this.init();
        this.setSrcBillModel(srcBillModel);
    }

    public static CoupleSettleBillsModel build(SettleBillModel supBillModel, SettleBillModel demBillModel) {
        CoupleSettleBillsModel billModel = new CoupleSettleBillsModel(supBillModel, demBillModel);
        billModel.init();
        return billModel;
    }

    protected CoupleSettleBillsModel(SettleBillModel supBillModel, SettleBillModel demBillModel) {
        super(supBillModel, demBillModel);
    }

    private void init() {
        SettleBillModel demBillModel;
        this.entryModelMap.clear();
        this.entries.clear();
        SettleBillModel supBillModel = (SettleBillModel)this.getSupBillModel();
        if (supBillModel != null) {
            for (SettleBillEntryModel entryModel : supBillModel.getEntries()) {
                CoupleSettleBillEntriesModel csbemodel;
                Long cpEntryId = (Long)entryModel.getValue("srcbillentryid");
                Long cpBillId = (Long)entryModel.getValue("srcbillid");
                String cpBillEntity = (String)entryModel.getValue("srcbillentity");
                if (CommonUtils.idIsNull(cpEntryId)) {
                    cpEntryId = entryModel.getId();
                }
                if ((csbemodel = this.entryModelMap.get(cpEntryId)) == null) {
                    Long mianBillEntryId = (Long)entryModel.getValue("mainbillentryid");
                    csbemodel = new CoupleSettleBillEntriesModel(cpEntryId, this, entryModel, null);
                    csbemodel.setMainEntryId(mianBillEntryId);
                    csbemodel.setSrcBillId(cpBillId);
                    csbemodel.setSrcBillEntity(cpBillEntity);
                    this.entries.add(csbemodel);
                    this.entryModelMap.put(cpEntryId, csbemodel);
                    continue;
                }
                csbemodel.setSupBillModel(entryModel);
            }
        }
        if ((demBillModel = (SettleBillModel)this.getDemBillModel()) != null) {
            for (SettleBillEntryModel entryModel : demBillModel.getEntries()) {
                Long srcBillEntryId = (Long)entryModel.getValue("srcbillentryid");
                Long cpBillId = (Long)entryModel.getValue("srcbillid");
                String cpBillEntity = (String)entryModel.getValue("srcbillentity");
                if (srcBillEntryId == null) continue;
                CoupleSettleBillEntriesModel csbemodel = this.entryModelMap.get(srcBillEntryId);
                if (csbemodel == null) {
                    Long mianBillEntryId = (Long)entryModel.getValue("mainbillentryid");
                    csbemodel = new CoupleSettleBillEntriesModel(srcBillEntryId, this, null, entryModel);
                    csbemodel.setMainEntryId(mianBillEntryId);
                    csbemodel.setSrcBillId(cpBillId);
                    csbemodel.setSrcBillEntity(cpBillEntity);
                    this.entries.add(csbemodel);
                    this.entryModelMap.put(srcBillEntryId, csbemodel);
                    continue;
                }
                csbemodel.setDemBillModel(entryModel);
            }
        }
    }

    public void initExrateTable(OrgAssistant orgAssistant) {
        if (this.getSupBillModel() != null) {
            ((SettleBillModel)this.getSupBillModel()).initExrateTable(orgAssistant);
        }
        if (this.getDemBillModel() != null) {
            ((SettleBillModel)this.getDemBillModel()).initExrateTable(orgAssistant);
        }
    }

    @Override
    public void setSrcBillModel(SettleBillModel srcBillModel) {
        for (Map.Entry<Long, CoupleSettleBillEntriesModel> cpModel : this.entryModelMap.entrySet()) {
            SettleBillEntryModel srcEntryModel = srcBillModel.getEntryModel(cpModel.getKey());
            cpModel.getValue().setSrcBillModel(srcEntryModel);
        }
        super.setSrcBillModel(srcBillModel);
    }

    public List<CoupleSettleBillEntriesModel> getEntries() {
        return this.entries;
    }

    public CoupleSettleBillEntriesModel getEntryBySrcEntryId(Long srcEntryId) {
        return this.entryModelMap.get(srcEntryId);
    }

    public void setExRateDate(Date exRateDate) {
        this.exRateDate = exRateDate;
    }

    public Date getExRateDate() {
        return this.exRateDate;
    }

    public void setSettleCurrencyId(Long settleCurrencyId) {
        this.settleCurrencyId = settleCurrencyId;
    }

    public Long getSettleCurrencyId() {
        return this.settleCurrencyId;
    }

    public Long getSupplierId() {
        return this.supplierId;
    }

    public Long getDemandId() {
        return this.demandId;
    }

    public DynamicObject getPriceRuleObj() {
        return this.priceRuleObj;
    }

    public void setPriceRuleObj(DynamicObject priceRuleObj) {
        this.priceRuleObj = priceRuleObj;
    }

    public DynamicObject getEntrySettleRelation() {
        if (this.relEntryModel != null) {
            return this.relEntryModel.getObj();
        }
        return null;
    }

    public void writeToBill() {
        if (this.getSupBillModel() != null) {
            ((SettleBillModel)this.getSupBillModel()).writeToBill();
        }
        if (this.getDemBillModel() != null) {
            ((SettleBillModel)this.getDemBillModel()).writeToBill();
        }
    }

    public void setEntryModel(RelationEntryModel entryModel) {
        this.relEntryModel = entryModel;
        this.supplierId = entryModel.getSupplierId();
        this.demandId = entryModel.getDemandId();
    }

    public RelationEntryModel getEntryModel() {
        return this.relEntryModel;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public void setDemandId(Long demandId) {
        this.demandId = demandId;
    }

    @Deprecated
    public void setEntrySettleRelation(DynamicObject entrySettleRelation) {
        this.relEntryModel = RelationEntryModel.create(entrySettleRelation);
    }

    public Map<Long, CoupleSettleBillEntriesModel> getEntryModelMap() {
        return this.entryModelMap;
    }
}

