/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.core.judge;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.orm.query.QFilter;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.control.FilterGridUtils;
import org.apache.commons.lang.StringUtils;

public class SettleNeoJudgeHandler
implements Comparable<SettleNeoJudgeHandler> {
    private Long id;
    private String billtype;
    private int priority = 0;
    private String settleOrgKey;
    private String settleOrgTypeKey;
    private String ownerOrgKey;
    private String ownerOrgTypeKey;
    private String settleRelationKey;
    private BOSExpression expr;
    private QFilter filter;

    public static SettleNeoJudgeHandler build(DynamicObject settleJudgecfg) {
        SettleNeoJudgeHandler handler = new SettleNeoJudgeHandler();
        handler.init(settleJudgecfg);
        return handler;
    }

    private SettleNeoJudgeHandler() {
    }

    private void init(DynamicObject object) {
        String lastKey;
        IDataEntityProperty findProperty;
        String itemClassType;
        if (object == null) {
            return;
        }
        this.id = object.getLong("id");
        this.billtype = object.getString("bill");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.billtype);
        this.settleOrgKey = object.getString("balanceorg");
        if (this.settleOrgKey != null && (itemClassType = DynamicObjectUtil.getItemClasstype(findProperty = entityType.findProperty(lastKey = DynamicObjectUtil.getLastKey(this.settleOrgKey)))) != null) {
            this.settleOrgTypeKey = itemClassType;
        }
        this.ownerOrgKey = object.getString("ownerorg");
        if (this.ownerOrgKey != null && (itemClassType = DynamicObjectUtil.getItemClasstype(findProperty = entityType.findProperty(lastKey = DynamicObjectUtil.getLastKey(this.ownerOrgKey)))) != null) {
            this.ownerOrgTypeKey = itemClassType;
        }
        this.settleRelationKey = object.getString("settlerelation");
        this.priority = object.getInt("priority");
        String filterStr = object.getString("billfilterstr_tag");
        if (StringUtils.isNotEmpty((String)filterStr)) {
            this.expr = FilterGridUtils.filterTextToExpression(this.billtype, filterStr);
            this.filter = FilterGridUtils.filterTextToQfilter(this.billtype, filterStr);
        }
    }

    public Set<String> getNeedQueryKeys() {
        HashSet<String> fields = new HashSet<String>(32);
        fields.add(this.settleOrgKey);
        fields.add(this.settleOrgTypeKey);
        fields.add(this.ownerOrgKey);
        fields.add(this.ownerOrgTypeKey);
        fields.add(this.settleRelationKey);
        if (this.expr != null) {
            fields.addAll(this.expr.getVars());
        }
        return fields;
    }

    public boolean isConfigSettleRelation() {
        return StringUtils.isNotEmpty((String)this.getSettleRelationKey());
    }

    public boolean isConfigSupAndDem() {
        return StringUtils.isNotEmpty((String)this.getOwnerOrgKey()) && StringUtils.isNotEmpty((String)this.getSettleOrgKey());
    }

    @Override
    public int compareTo(SettleNeoJudgeHandler o) {
        return o.priority - this.priority;
    }

    public String getOwnerOrgKey() {
        return this.ownerOrgKey;
    }

    public String getSettleOrgKey() {
        return this.settleOrgKey;
    }

    public String getSettleRelationKey() {
        return this.settleRelationKey;
    }

    public Long getId() {
        return this.id;
    }

    public BOSExpression getExpr() {
        return this.expr;
    }

    public String getOwnerOrgTypeKey() {
        return this.ownerOrgTypeKey;
    }

    public String getSettleOrgTypeKey() {
        return this.settleOrgTypeKey;
    }

    public QFilter getFilter() {
        return this.filter;
    }
}

