/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.core.judge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.core.judge.SettleNeoJudgeHandler;

public class SettleNeoJudgement {
    private final String billType;
    private List<SettleNeoJudgeHandler> handlers = new ArrayList<SettleNeoJudgeHandler>();

    private SettleNeoJudgement(String billType) {
        this.billType = billType;
    }

    public static SettleNeoJudgement create(String billtype) {
        SettleNeoJudgement sbJudgement = new SettleNeoJudgement(billtype);
        sbJudgement.init();
        return sbJudgement;
    }

    public void init() {
        QFilter filter = new QFilter("bill", "=", (Object)this.billType).and("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection settleJudgements = QueryServiceHelper.query((String)"ism_interorgsettlecfg", (String)"id, bill, number, balanceorg, ownerorg, settlerelation, billfilterstr, billfilterstr_tag, priority", (QFilter[])filter.toArray(), (String)"priority asc");
        if (settleJudgements == null || settleJudgements.isEmpty()) {
            return;
        }
        for (DynamicObject settleJudgement : settleJudgements) {
            SettleNeoJudgeHandler handler = SettleNeoJudgeHandler.build(settleJudgement);
            this.handlers.add(handler);
        }
    }

    public Map<Long, SettleNeoJudgeHandler> getBillHandler(Collection<Long> billIds) {
        if (this.handlers == null) {
            return new HashMap<Long, SettleNeoJudgeHandler>(128);
        }
        Set<String> allNeedQueryKeys = this.getAllNeedQueryKeys();
        allNeedQueryKeys.add("id");
        allNeedQueryKeys.remove("");
        allNeedQueryKeys.remove(null);
        if (this.handlers.size() == 1) {
            return this.judgeByDBQuery(this.handlers.get(0), billIds, allNeedQueryKeys);
        }
        return this.judgeByFormulaEngine(billIds, allNeedQueryKeys);
    }

    private Map<Long, SettleNeoJudgeHandler> judgeByDBQuery(SettleNeoJudgeHandler handler, Collection<Long> billIds, Set<String> allNeedQueryKeys) {
        DynamicObjectCollection billInfos = QueryServiceHelper.query((String)"SettleNeoJudgement.getBillHandler", (String)this.billType, (String)CommonUtils.transToStr(allNeedQueryKeys), (QFilter[])new QFilter("id", "in", billIds).and(handler.getFilter()).toArray(), (String)"id asc");
        LinkedList objs = new LinkedList(billInfos);
        HashMap<Long, SettleNeoJudgeHandler> idToHandler = new HashMap<Long, SettleNeoJudgeHandler>(billIds.size());
        boolean isConfigSR = handler.isConfigSettleRelation();
        boolean isConfigSD = handler.isConfigSupAndDem();
        for (DynamicObject billRowInfo : objs) {
            Long billId = billRowInfo.getLong("id");
            if (idToHandler.containsKey(billId) || !this.checkCanSettle(handler, isConfigSR, isConfigSD, billRowInfo)) continue;
            idToHandler.put(billId, handler);
        }
        return idToHandler;
    }

    private Map<Long, SettleNeoJudgeHandler> judgeByFormulaEngine(Collection<Long> billIds, Set<String> allNeedQueryKeys) {
        DynamicObjectCollection billInfos = QueryServiceHelper.query((String)"SettleNeoJudgement.getBillHandler", (String)this.billType, (String)CommonUtils.transToStr(allNeedQueryKeys), (QFilter[])new QFilter("id", "in", billIds).toArray(), (String)"id asc");
        LinkedList objs = new LinkedList(billInfos);
        HashMap<Long, SettleNeoJudgeHandler> idToHandler = new HashMap<Long, SettleNeoJudgeHandler>(billIds.size());
        for (SettleNeoJudgeHandler handler : this.handlers) {
            boolean isConfigSR = handler.isConfigSettleRelation();
            boolean isConfigSD = handler.isConfigSupAndDem();
            Iterator iterator = objs.iterator();
            while (iterator.hasNext()) {
                DynamicObject billRowInfo = (DynamicObject)iterator.next();
                Long billId = billRowInfo.getLong("id");
                if (idToHandler.containsKey(billId)) {
                    iterator.remove();
                    continue;
                }
                if (!this.isMatchFilter(handler, billRowInfo)) continue;
                iterator.remove();
                if (!this.checkCanSettle(handler, isConfigSR, isConfigSD, billRowInfo)) continue;
                idToHandler.put(billId, handler);
            }
        }
        return idToHandler;
    }

    private boolean checkCanSettle(SettleNeoJudgeHandler handler, boolean isConfigSR, boolean isConfigSD, DynamicObject billRowInfo) {
        if (isConfigSR && billRowInfo.getLong(handler.getSettleRelationKey()) != 0L) {
            return true;
        }
        if (isConfigSD) {
            long onwerId = billRowInfo.getLong(handler.getOwnerOrgKey());
            if (handler.getOwnerOrgTypeKey() != null && !"bos_org".equals(billRowInfo.getString(handler.getOwnerOrgTypeKey()))) {
                return false;
            }
            long settleOrgId = billRowInfo.getLong(handler.getSettleOrgKey());
            if (handler.getSettleOrgTypeKey() != null && !"bos_org".equals(billRowInfo.getString(handler.getSettleOrgTypeKey()))) {
                return false;
            }
            return onwerId != 0L && settleOrgId != 0L && onwerId != settleOrgId;
        }
        return false;
    }

    private boolean isMatchFilter(SettleNeoJudgeHandler handler, DynamicObject billRowInfo) {
        BOSExpression expr = handler.getExpr();
        HashMap<String, Object> ctx = new HashMap<String, Object>(16);
        Set vars = expr.getVars();
        if (vars.isEmpty()) {
            return true;
        }
        for (String var : vars) {
            ctx.put(var, billRowInfo.get(var));
        }
        return (Boolean)FormulaEngine.execExcelFormula((Expr)expr.getExpr(), ctx, null);
    }

    public Set<String> getAllNeedQueryKeys() {
        HashSet<String> keys = new HashSet<String>(this.handlers.size());
        for (SettleNeoJudgeHandler handler : this.handlers) {
            keys.addAll(handler.getNeedQueryKeys());
        }
        return keys;
    }
}

