/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.core.unsettle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.scmc.ism.business.helper.BizFlowServiceHelper;
import kd.scmc.ism.business.helper.SettleLogHelper;
import kd.scmc.ism.common.errocode.ISMErrorCode;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.core.AbstractBizOperSplitter;

public class UnSettleOperSplitter
extends AbstractBizOperSplitter {
    private Set<Long> noGenIds = new HashSet<Long>(64);
    private Map<Long, List<Long>> deleteIds = new HashMap<Long, List<Long>>(64);
    private Map<Long, DynamicObject> deleteBills = new HashMap<Long, DynamicObject>(64);

    public static UnSettleOperSplitter doParseByLogIds(List<Long> logIds) {
        return null;
    }

    public static UnSettleOperSplitter doParseByBillIds(Collection<Long> billIds) {
        DynamicObject[] settleLogInfos = SettleLogHelper.getLogInfoBySrcIds(billIds);
        if (settleLogInfos == null || settleLogInfos.length == 0) {
            return UnSettleOperSplitter.buildExecute(billIds);
        }
        return UnSettleOperSplitter.buildFromSettleLog(billIds, settleLogInfos);
    }

    private static UnSettleOperSplitter buildExecute(Collection<Long> billIds) {
        UnSettleOperSplitter operInfo = new UnSettleOperSplitter();
        ErrorCode code = ISMErrorCode.noSettleBillUnSettleFail();
        for (Long billId : billIds) {
            operInfo.addFailIdAndReason(billId, code);
        }
        return operInfo;
    }

    private static UnSettleOperSplitter buildFromSettleLog(Collection<Long> billIds, DynamicObject[] settleLogInfos) {
        UnSettleOperSplitter operInfo = new UnSettleOperSplitter();
        operInfo.initInfoFromLogObjs(settleLogInfos);
        operInfo.parseLog(billIds);
        return operInfo;
    }

    private void parseLog(Collection<Long> billIds) {
        Map<Long, SettleLogHandler> logHandlers = this.getLogHandlers();
        HashSet<Long> checkFlowExecute = new HashSet<Long>(16);
        for (SettleLogHandler logHandler : logHandlers.values()) {
            DynamicObjectCollection entries = logHandler.getDataLogInfo();
            for (DynamicObject entry : entries) {
                Object flowObj = entry.get("bizflow");
                if (flowObj == null) continue;
                checkFlowExecute.add(entry.getLong("settlebillid"));
            }
        }
        Set<Long> flowExecutionIds = BizFlowServiceHelper.getBizFlowExecutionByIds(checkFlowExecute);
        for (Long billId : billIds) {
            SettleLogHandler settleLog = this.getLogHandlers().get(billId);
            if (settleLog == null) {
                this.addFailIdAndReason(billId, ISMErrorCode.noSettleBillUnSettleFail());
                continue;
            }
            List<Long> allExecBillIds = settleLog.getSequence().getAllExecBillIds();
            if (allExecBillIds.isEmpty()) {
                this.noGenIds.add(billId);
                this.addFailIdAndReason(billId, ISMErrorCode.noSettleBillUnSettleFail());
                continue;
            }
            boolean isFlowExecute = false;
            int notExistBillCount = 0;
            ArrayList<DynamicObject> vBills = new ArrayList<DynamicObject>(16);
            for (Long settleBillId : settleLog.getSequence().getAllExecBillIds()) {
                DynamicObject bill = this.getBillInfos().get(settleBillId);
                if (bill == null) {
                    ++notExistBillCount;
                    continue;
                }
                if (flowExecutionIds.contains(settleBillId)) {
                    isFlowExecute = true;
                }
                vBills.add(bill);
            }
            if (isFlowExecute) {
                this.addFailIdAndReason(billId, ISMErrorCode.bizFlowExcute());
                continue;
            }
            if (notExistBillCount == allExecBillIds.size()) {
                this.addFailIdAndReason(billId, ISMErrorCode.noSettleBillUnSettleFail());
                continue;
            }
            this.addDeleteBills(billId, vBills);
        }
    }

    private void addDeleteBills(Long billId, Collection<DynamicObject> settleBills) {
        ArrayList<Long> settlebillIds = new ArrayList<Long>(settleBills.size());
        for (DynamicObject settleBill : settleBills) {
            if (settleBill == null) continue;
            Long settleBillId = DynamicObjectUtil.getPkValue(settleBill);
            settlebillIds.add(settleBillId);
            this.deleteBills.put(settleBillId, settleBill);
        }
        this.deleteIds.put(billId, settlebillIds);
    }

    public Map<Long, List<Long>> getDeleteIds() {
        return this.deleteIds;
    }

    public Map<Long, DynamicObject> getDeleteBills() {
        return this.deleteBills;
    }

    public Set<Long> getNoGenIds() {
        return this.noGenIds;
    }
}

