/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.core.unsettle.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.log.api.AppLogInfo;
import kd.scmc.ism.business.helper.AppLogInfoHelper;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.common.result.BatchBillOpResult;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.model.core.unsettle.IUnSettleOper;
import kd.scmc.ism.model.core.unsettle.UnSettleOperSplitter;
import kd.scmc.ism.model.flow.BillBatchFlowExecutor;
import kd.scmc.ism.model.log.SettleLogBatchUpdater;

public class UnSettleOperExecute
implements IUnSettleOper {
    @Override
    public SettleOperResult doSettleOper(UnSettleOperSplitter splitter) {
        Map<Long, List<Long>> deleteIds = splitter.getDeleteIds();
        if (CommonUtils.mapIsEmpty(deleteIds)) {
            return new SettleOperResult();
        }
        this.doOperLogRecord(splitter);
        BillBatchFlowExecutor executor = new BillBatchFlowExecutor();
        executor.addBills(splitter.getDeleteBills().values());
        BatchBillOpResult positiveExecute = executor.negativeExecute();
        return this.updateLog(positiveExecute, splitter.getDeleteIds());
    }

    private void doOperLogRecord(UnSettleOperSplitter splitter) {
        Map<Long, List<Long>> deleteIds = splitter.getDeleteIds();
        ArrayList<AppLogInfo> logInfos = new ArrayList<AppLogInfo>(16);
        String opName = ModelLang.unsettleOp();
        for (Long billId : deleteIds.keySet()) {
            SettleLogHandler logHandler = splitter.getLogHandlers().get(billId);
            DynamicObject dataLog = logHandler.getDataLog();
            DynamicObject type = dataLog.getDynamicObject("sourcetype");
            String entityType = type.getString("number");
            String billNo = dataLog.getString("sourcenum");
            logInfos.add(AppLogInfoHelper.buildAppLogInfo(opName, billNo, billId, entityType));
        }
        AppLogInfoHelper.batchOperLog(logInfos);
    }

    private SettleOperResult updateLog(BatchBillOpResult positiveExecute, Map<Long, List<Long>> map) {
        SettleLogBatchUpdater logsUpd = new SettleLogBatchUpdater();
        SettleOperResult operResult = new SettleOperResult();
        for (Map.Entry<Long, List<Long>> redoList : map.entrySet()) {
            Long redoBillId = redoList.getKey();
            boolean isFailed = false;
            StringBuilder str = new StringBuilder();
            for (Long stBillId : redoList.getValue()) {
                String billstatus = positiveExecute.getBillStatusInfo().get(stBillId);
                String failReason = positiveExecute.getFailReasonInfo().get(stBillId);
                if (failReason == null) {
                    failReason = "";
                } else {
                    str.append(failReason);
                    isFailed = true;
                }
                logsUpd.addSettleStatusInfo(redoBillId, stBillId, billstatus, failReason);
            }
            if (!isFailed) continue;
            operResult.addFailInfo(redoBillId, str.toString());
        }
        logsUpd.updateLogInfo();
        return operResult;
    }
}

