/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.flow;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BillEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.ism.common.result.BatchBillOpResult;
import kd.scmc.ism.common.result.BatchOpExecuteResult;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.flow.StatusBillGroupFactory;
import kd.scmc.ism.model.flow.sequence.GenSequenceExecutor;
import kd.scmc.ism.model.flow.statusgroup.AbstractStatusBillGroup;

public class BillBatchFlowExecutor {
    private static final String[] STATUS = new String[]{"NOSAVE", "A", "B", "C"};
    private Map<Long, String> initBillStatus = new HashMap<Long, String>(64);
    private Map<String, AbstractStatusBillGroup> statusGroups = new HashMap<String, AbstractStatusBillGroup>(16);

    public BillBatchFlowExecutor() {
        for (String status : STATUS) {
            this.statusGroups.put(status, StatusBillGroupFactory.create(status));
        }
    }

    public void addBills(Collection<DynamicObject> bills) {
        for (DynamicObject bill : bills) {
            this.addBill(bill);
        }
    }

    public void addBill(DynamicObject bill) {
        BillEntityType et = (BillEntityType)bill.getDataEntityType();
        String status = bill.getString(et.getBillStatus());
        AbstractStatusBillGroup statusGroup = this.statusGroups.get(status);
        if (statusGroup == null) {
            throw new KDBizException(status + " STATUS NOT SUPPORT!");
        }
        statusGroup.addBill(bill);
        this.initBillStatus.put(DynamicObjectUtil.getPkValue(bill), status);
    }

    public void addNoSavedBills(Collection<DynamicObject> bills) {
        for (DynamicObject bill : bills) {
            this.addNoSavedBill(bill);
        }
    }

    public void addNoSavedBill(DynamicObject bill) {
        AbstractStatusBillGroup noSaveBillGroup = this.statusGroups.get("NOSAVE");
        noSaveBillGroup.addBill(bill);
        this.initBillStatus.put(DynamicObjectUtil.getPkValue(bill), "NOSAVE");
    }

    public BatchBillOpResult positiveExecute() {
        return this.positiveExecute(null);
    }

    public BatchBillOpResult positiveExecute(Collection<List<Long>> genSequences) {
        BatchBillOpResult billsResult = new BatchBillOpResult(this.initBillStatus);
        for (int i = 0; i < STATUS.length; ++i) {
            String status = STATUS[i];
            AbstractStatusBillGroup billGroup = this.statusGroups.get(status);
            if (billGroup.isEmpty()) continue;
            BatchOpExecuteResult executeResult = null;
            try (TraceSpan trace = Tracer.create((String)("AbstractStatusBillGroup-" + billGroup.getBillstatus()), (String)"positiveExecute()");){
                executeResult = "B".equals(status) ? billGroup.positiveExecute(new GenSequenceExecutor(genSequences)) : billGroup.positiveExecute();
                billsResult.updateExecuteInfo(executeResult, billGroup);
            }
            if (executeResult == null) break;
            AbstractStatusBillGroup nextGroup = this.statusGroups.get(executeResult.getTargetStatus());
            if (nextGroup == null) continue;
            if (executeResult.isSuccess()) {
                billGroup.transBillToGroup(nextGroup);
                continue;
            }
            Set<Long> failedIds = executeResult.getFailedBillMessage().keySet();
            HashSet<Long> exculudeIds = new HashSet<Long>(failedIds);
            for (Long failedId : failedIds) {
                for (List<Long> sequens : genSequences) {
                    if (!sequens.contains(failedId)) continue;
                    exculudeIds.addAll(sequens);
                }
            }
            billGroup.transBillToGroup(nextGroup, exculudeIds);
        }
        return billsResult;
    }

    public BatchBillOpResult negativeExecute() {
        BatchBillOpResult billsResult = new BatchBillOpResult(this.initBillStatus);
        for (int i = STATUS.length - 1; i > 0; --i) {
            String status = STATUS[i];
            AbstractStatusBillGroup billGroup = this.statusGroups.get(status);
            if (billGroup.isEmpty()) continue;
            BatchOpExecuteResult executeResult = null;
            try (TraceSpan trace = Tracer.create((String)("AbstractStatusBillGroup-" + billGroup.getBillstatus()), (String)"negativeExecute()");){
                executeResult = billGroup.negativeExecute();
                billsResult.updateExecuteInfo(executeResult, billGroup);
            }
            if (executeResult == null || !executeResult.isSuccess()) break;
            AbstractStatusBillGroup nextGroup = this.statusGroups.get(executeResult.getTargetStatus());
            if (nextGroup == null) continue;
            billGroup.transBillToGroup(nextGroup);
        }
        return billsResult;
    }
}

