/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.flow.sequence;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.common.result.BatchOpExecuteResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.OperationUtil;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.model.flow.sequence.ISequenceExecutor;

public abstract class AbstractSequenceExecutor
implements ISequenceExecutor {
    private static final Log log = LogFactory.getLog(AbstractSequenceExecutor.class);

    protected void executeOp(String op, String billEntity, Map<Long, DynamicObject> billInfos, BatchOpExecuteResult result) {
        if (CommonUtils.mapIsEmpty(billInfos)) {
            return;
        }
        try (TXHandle tx = TX.notSupported((String)("BillGroupHandle-" + op));){
            try {
                OperationResult opResult = null;
                OperateOption operateOption = this.getOptionByOper(op);
                long start = System.currentTimeMillis();
                if ("save".equals(op)) {
                    Collection<DynamicObject> billObjs = billInfos.values();
                    opResult = OperationServiceHelper.executeOperate((String)op, (String)billEntity, (DynamicObject[])billObjs.toArray(new DynamicObject[billObjs.size()]), (OperateOption)operateOption);
                } else {
                    Set<Long> billIds = billInfos.keySet();
                    opResult = OperationServiceHelper.executeOperate((String)op, (String)billEntity, (Object[])billIds.toArray(new Object[billIds.size()]), (OperateOption)operateOption);
                }
                long end = System.currentTimeMillis();
                log.info("\u5355\u636e\uff1a" + billEntity + "\u6267\u884c" + op + "\u64cd\u4f5c\u7ed3\u675f\uff0c\u5355\u636e\u91cf\uff1a" + billInfos.size() + "\uff0c\u4e00\u5171\u8017\u65f6\uff1a" + (end - start) + "ms");
                if (!opResult.isSuccess()) {
                    Map<Long, String> failedBillMessage = this.handleFailInfo(op, opResult, billInfos);
                    result.addFailBillMessages(failedBillMessage);
                }
            }
            catch (Exception e) {
                HashMap<Long, String> failedBillMessage = new HashMap<Long, String>(billInfos.size());
                for (Long pkInfo : billInfos.keySet()) {
                    failedBillMessage.put(pkInfo, ModelLang.billExecuteOperErro(op) + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
                result.addFailBillMessages(failedBillMessage);
            }
        }
    }

    private OperateOption getOptionByOper(String op) {
        OperateOption option = null;
        option = "save".equals(op) || "submit".equals(op) ? OperationUtil.getBackCallsNoMutexOption() : OperationUtil.getBackCallsOption();
        return option;
    }

    protected Map<Long, String> handleFailInfo(String op, OperationResult result, Map<Long, DynamicObject> billInfos) {
        HashMap<Long, String> failedBillMessage;
        block5: {
            List allErrorOrValidateInfo;
            block4: {
                op = ModelLang.getOperName(op);
                allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
                failedBillMessage = new HashMap<Long, String>(allErrorOrValidateInfo.size());
                if (!allErrorOrValidateInfo.isEmpty()) break block4;
                String erroMessage = result.getMessage();
                List successPkIds = result.getSuccessPkIds();
                for (Map.Entry<Long, DynamicObject> billMapEntry : billInfos.entrySet()) {
                    Long billId = billMapEntry.getKey();
                    if (successPkIds.contains(billId)) continue;
                    String billNo = billMapEntry.getValue().getString("billno");
                    failedBillMessage.put(billId, ModelLang.billExecuteOperUnSuccess(billNo, op, erroMessage));
                }
                break block5;
            }
            boolean isNullId = false;
            StringBuilder nullIdFailReason = new StringBuilder();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                if (iOperateInfo == null) continue;
                if (iOperateInfo.getPkValue() == null) {
                    isNullId = true;
                    nullIdFailReason.append(iOperateInfo.getMessage());
                    continue;
                }
                Long billId = Long.valueOf(iOperateInfo.getPkValue().toString());
                String failInfo = (String)failedBillMessage.get(billId);
                failInfo = StringUtils.isEmpty((CharSequence)failInfo) ? (StringUtils.isEmpty((CharSequence)result.getMessage()) ? iOperateInfo.getMessage() + "   " : result.getMessage() + iOperateInfo.getMessage() + "   ") : failInfo + " " + iOperateInfo.getMessage() + "   ";
                failedBillMessage.put(billId, failInfo);
            }
            if (!isNullId) break block5;
            for (Long allId : billInfos.keySet()) {
                failedBillMessage.put(allId, ModelLang.operValiInfoIdIsNull(op, nullIdFailReason.toString()));
            }
        }
        return failedBillMessage;
    }
}

