/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.flow.statusgroup;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.result.BatchOpExecuteResult;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.flow.sequence.ISequenceExecutor;
import kd.scmc.ism.model.flow.sequence.RandomSequenceBatchExecutor;

public abstract class AbstractStatusBillGroup {
    private final String billstatus;
    private Map<String, Map<Long, DynamicObject>> entityToBillMap = new HashMap<String, Map<Long, DynamicObject>>(16);

    public AbstractStatusBillGroup(String billstatus) {
        this.billstatus = billstatus;
    }

    public void addBill(DynamicObject bill) {
        String entity = bill.getDataEntityType().getName();
        Map<Long, DynamicObject> map = this.entityToBillMap.get(entity);
        if (map == null) {
            map = new HashMap<Long, DynamicObject>(16);
            this.entityToBillMap.put(entity, map);
        }
        map.put(DynamicObjectUtil.getPkValue(bill), bill);
    }

    public void addBills(Collection<DynamicObject> bills) {
        for (DynamicObject bill : bills) {
            this.addBill(bill);
        }
    }

    private void addBills(Map<String, Map<Long, DynamicObject>> spBills) {
        for (Map.Entry<String, Map<Long, DynamicObject>> spBillsEntry : spBills.entrySet()) {
            String entity = spBillsEntry.getKey();
            Map<Long, DynamicObject> values = spBillsEntry.getValue();
            Map<Long, DynamicObject> billInfo = this.entityToBillMap.get(entity);
            if (billInfo == null) {
                this.entityToBillMap.put(entity, values);
                continue;
            }
            billInfo.putAll(values);
        }
    }

    public Map<String, Map<Long, DynamicObject>> getEntityToBillMap() {
        return this.entityToBillMap;
    }

    public BatchOpExecuteResult positiveExecute() {
        return this.positiveExecute(RandomSequenceBatchExecutor.getInstance());
    }

    public abstract BatchOpExecuteResult positiveExecute(ISequenceExecutor var1);

    public abstract BatchOpExecuteResult negativeExecute();

    protected final BatchOpExecuteResult batchCallOperate(String op) {
        return this.batchCallOperate(op, RandomSequenceBatchExecutor.getInstance());
    }

    protected final BatchOpExecuteResult batchCallOperate(String op, ISequenceExecutor execSequence) {
        return execSequence.execute(op, this.entityToBillMap);
    }

    public void transBillToGroup(AbstractStatusBillGroup group) {
        group.addBills(this.getEntityToBillMap());
        this.entityToBillMap.clear();
    }

    public void transBillToGroup(AbstractStatusBillGroup group, Collection<Long> excludeIds) {
        this.transBillToGroup(group);
        Map<String, Map<Long, DynamicObject>> nextEntityMap = group.entityToBillMap;
        for (Map<Long, DynamicObject> billInfos : nextEntityMap.values()) {
            Iterator<Map.Entry<Long, DynamicObject>> iterator = billInfos.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, DynamicObject> next = iterator.next();
                if (!excludeIds.contains(next.getKey())) continue;
                iterator.remove();
            }
        }
        this.entityToBillMap.clear();
    }

    public boolean isEmpty() {
        for (Map<Long, DynamicObject> billInfos : this.entityToBillMap.values()) {
            if (billInfos.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String getBillstatus() {
        return this.billstatus;
    }
}

